'use strict';

require('../common');

const { test, assert_true, assert_throws } =
  require('../common/wpt');

/* eslint-disable max-len, object-curly-spacing */

/* The following tests should not be modified as they are copied */
/* WPT Refs:
   https://github.com/web-platform-tests/wpt/blob/6f0a96ed650935b17b6e5d277889cfbe0ccc103e/console/console-label-conversion.any.js
   License: https://github.com/web-platform-tests/wpt/blob/6f0a96ed650935b17b6e5d277889cfbe0ccc103e/LICENSE.md
*/

// https://console.spec.whatwg/org/#counting
// https://console.spec.whatwg/org/#timing

const methods = ['count', 'countReset', 'time', 'timeLog', 'timeEnd'];

for (const method of methods) {
  test(() => {
    let labelToStringCalled = false;

    console[method]({
      toString() {
        labelToStringCalled = true;
      }
    });

    assert_true(labelToStringCalled, `${method}() must call toString() on label when label is an object`);
  }, `console.${method}()'s label gets converted to string via label.toString() when label is an object`);

  test(() => {
    assert_throws({name: 'Error'}, () => {
      console[method]({
        toString() {
          throw new Error('conversion error');
        }
      });
    }, `${method} must re-throw any exceptions thrown by label.toString() conversion`);
  }, `console.${method}() throws exceptions generated by erroneous label.toString() conversion`);
}

/* eslint-enable */
