/*
 * Nightshade (TM) astronomy simulation and visualization
 *
 * Copyright (C) 2005 Fabien Chereau
 * Copyright (C) 2009 Digitalis Education Solutions, Inc.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Nightshade is a trademark of Digitalis Education Solutions, Inc.
 * See the TRADEMARKS file for trademark usage requirements.
 *
 */

// This file contains translations for all translatable strings stored within data files
// It is not meant to be compiled but just parsed by gettext

class Translations
{
	void Translations() {
		;
	}

	static translationList() {
		// Generate Gettext strings for traduction
		assert(0);

		// Planets and satellites from ssystem.ini
		N_("Sun");
		N_("Mercury");
		N_("Venus");
		N_("Earth");
		N_("Moon");
		N_("Mars");
		N_("Phobos");
		N_("Deimos ");
		N_("Ceres");
		N_("Jupiter");
		N_("Io");
		N_("Europa");
		N_("Ganymede");
		N_("Callisto");
		N_("Amalthea");
		N_("Himalia");
		N_("Elara");
		N_("Pasiphae");
		N_("Sinope");
		N_("Lysithea");
		N_("Carme");
		N_("Ananke");
		N_("Leda");
		N_("Thebe");
		N_("Adrastea");
		N_("Metis");
		N_("Saturn");
		N_("Mimas");
		N_("Enceladus");
		N_("Tethys");
		N_("Dione");
		N_("Rhea");
		N_("Titan");
		N_("Hyperion");
		N_("Iapetus");
		N_("Uranus");
		N_("Miranda");
		N_("Ariel");
		N_("Umbriel");
		N_("Titania");
		N_("Oberon");
		N_("Cordelia");
		N_("Ophelia");
		N_("Bianca");
		N_("Desdemona");
		N_("Juliet");
		N_("Portia");
		N_("Rosalind");
		N_("Belinda");
		N_("Puck");
		N_("Caliban");
		N_("Sycorax");
		N_("Prospero");
		N_("Setebos");
		N_("Stephano");
		N_("Trinculo");
		N_("Francisco");
		N_("Margaret");
		N_("Ferdinand");
		N_("Perdita");
		N_("Mab");
		N_("Cupid");
		N_("Neptune");
		N_("Triton");
		N_("Neried");
		N_("Naiad");
		N_("Thalassa");
		N_("Despina");
		N_("Galatea");
		N_("Larissa");
		N_("Proteus");
		N_("Halimede");
		N_("Psamathe");
		N_("Sao");
		N_("Laomedeia");
		N_("Neso");
		N_("Pluto");
		N_("Charon");
		N_("Eris");
		N_("Solar System Observer");

		// Cardinals names
		N_("N");	// North
		N_("S");	// South
		N_("E");	// East
		N_("W");	// West

		// Constellation cultures
		N_("Chinese");
		N_("Egyptian");
		N_("Hindu");
		N_("Inuit");
		N_("Inuit (color)");
		N_("Lakota");
		N_("Navajo");
		N_("Norse");
		N_("Polynesian");
		N_("Sami");
		N_("Western");
		N_("Western (modern)");
		N_("Western (color)");


		// Western Constellations
		N_("Aquila");				// aql
		N_("Andromeda");			// and
		N_("Sculptor");			// scl
		N_("Ara");				// ara
		N_("Libra");				// lib
		N_("Cetus");				// cet
		N_("Aries");				// ari
		N_("Scutum");				// sct
		N_("Pyxis");				// pyx
		N_("Bootes");				// boo
		N_("Caelum");				// cae
		N_("Chamaeleon");			// cha
		N_("Cancer");				// cnc
		N_("Capricornus");		// cap
		N_("Carina");				// car
		N_("Cassiopeia");			// cas
		N_("Centaurus");			// cen
		N_("Cepheus");			// cep
		N_("Coma Berenices");		// com
		N_("Canes Venatici");		// cvn
		N_("Auriga");				// aur
		N_("Columba");			// col
		N_("Circinus");			// cir
		N_("Crater");				// crt
		N_("Corona Australis");	// cra
		N_("Corona Borealis");	// crb
		N_("Corvus");				// crv
		N_("Crux");				// cru
		N_("Cygnus");				// cyg
		N_("Delphinus");			// del
		N_("Dorado");				// dor
		N_("Draco");				// dra
		N_("Norma");				// nor
		N_("Eridanus");			// eri
		N_("Sagitta");			// sge
		N_("Fornax");				// for
		N_("Gemini");				// gem
		N_("Camelopardalis");		// cam
		N_("Canis Major");		// cma
		N_("Ursa Major");			// uma
		N_("Grus");				// gru
		N_("Hercules");			// her
		N_("Horologium");			// hor
		N_("Hydra");				// hya
		N_("Hydrus");				// hyi
		N_("Indus");				// ind
		N_("Lacerta");			// lac
		N_("Monoceros");			// mon
		N_("Lepus");				// lep
		N_("Leo");				// leo
		N_("Lupus");				// lup
		N_("Lynx");				// lyn
		N_("Lyra");				// lyr
		N_("Antlia");				// ant
		N_("Microscopium");		// mic
		N_("Musca");				// mus
		N_("Octans");				// oct
		N_("Apus");				// aps
		N_("Ophiuchus");			// oph
		N_("Orion");				// ori
		N_("Pavo");				// pav
		N_("Pegasus");			// peg
		N_("Pictor");				// pic
		N_("Perseus");			// per
		N_("Equuleus");			// equ
		N_("Canis Minor");		// cmi
		N_("Leo Minor");			// lmi
		N_("Vulpecula");			// vul
		N_("Ursa Minor");			// umi
		N_("Phoenix");			// phe
		N_("Piscis Austrinus");	// psc
		N_("Pisces");				// psa
		N_("Volans");				// vol
		N_("Puppis");				// pup
		N_("Reticulum");			// ret
		N_("Sagittarius");		// sgr
		N_("Scorpius");			// sco
		N_("Scutum");				// sct
		N_("Serpens");			// ser
		N_("Sextans");			// sex
		N_("Mensa");				// men
		N_("Taurus");				// tau
		N_("Telescopium");		// tel
		N_("Tucana");				// tuc
		N_("Triangulum");			// tri
		N_("Triangulum Australe");// tra
		N_("Aquarius");			// aqr
		N_("Virgo");				// vir
		N_("Vela");				// vel

		// Egyptian Constellations
		N_("Bull's Foreleg");   // 001
		N_("Two Poles");        // 002
		N_("Lion");     // 003
		N_("Two Jaws"); // 004
		N_("Sah");      // 005
		N_("Bird");     // 006
		N_("Sek");      // 007
		N_("Triangle"); // 008
		N_("Ferry Boat");       // 009
		N_("Boat");     // 010
		N_("Crocodile");        // 011
		N_("Selkis");   // 012
		N_("Prow");     // 013
		N_("Horus");    // 014
		N_("Sheepfold");        // 015
		N_("Giant");    // 016
		N_("Hippopotamus");     // 017
		N_("Flock");    // 018
		N_("Pair of Stars");    // 019
		N_("Khanuwy Fish");     // 020
		N_("Net");      // 021
		N_("Jaw");      // 022
		N_("Mooring Post");     // 023
		N_("Kenemet");  // 024
		N_("Chematy");  // 025
		N_("Waty Bekety");      // 026
		N_("Sheep");    // 027
		N_("Stars of Water");   // 028

		// Chinese Constellations
		N_("Northern Dipper");  // 001
		N_("Curved Array");     // 002
		N_("Coiled Thong");     // 003
		N_("Wings");    // 004
		N_("Chariot");  // 005
		N_("Tail");     // 006
		N_("Winnowing Basket"); // 007
		N_("Dipper");   // 008
		N_("Drum");     // 009
		N_("Three Steps");      // 010
		N_("Imperial Guards");  // 011
		N_("Horn");     // 012
		N_("Willow");   // 013
		N_("Imperial Passageway");      // 014
		N_("Kitchen");  // 015
		N_("River Turtle");     // 016
		N_("Stomach");  // 017
		N_("Great General");    // 018
		N_("Wall");     // 019
		N_("Legs");     // 020
		N_("Root");     // 021
		N_("Ramparts"); // 022
		N_("Flying Corridor");  // 023
		N_("Outer Fence");      // 024
		N_("Ford");     // 025
		N_("Seven Excellencies");       // 026
		N_("Market");   // 028
		N_("Five Chariots");    // 030
		N_("Rolled Tongue");    // 031
		N_("Net");      // 032
		N_("Toilet");   // 033
		N_("Screen");   // 034
		N_("Soldiers Market");  // 035
		N_("Square Granary");   // 036
		N_("Three Stars");      // 037
		N_("Four Channels");    // 038
		N_("Well");     // 039
		N_("South River");      // 040
		N_("North River");      // 041
		N_("Five Feudal Kings");        // 042
		N_("Orchard");  // 043
		N_("Meadows");  // 044
		N_("Circular Granary"); // 045
		N_("Purple Palace");    // 046
		N_("Extended Net");     // 047
		N_("Arsenal");  // 048
		N_("Hook");     // 049
		N_("Supreme Palace");   // 050
		N_("Jade Well");        // 051
		N_("Lance");    // 052
		N_("Boat");     // 053
		N_("Mausoleum");        // 054
		N_("Dog");      // 055
		N_("Earth God's Temple");       // 056
		N_("Bow and Arrow");    // 057
		N_("Pestle");   // 058
		N_("Mortar");   // 059
		N_("Rooftop");  // 060
		N_("Thunderbolt");      // 061
		N_("Chariot Yard");     // 062
		N_("Good Gourd");       // 063
		N_("Rotten Gourd");     // 064
		N_("Encampment");       // 065
		N_("Thunder and Lightning");    // 066
		N_("Palace Gate");      // 067
		N_("Emptiness");        // 068
		N_("Weaving Girl");     // 069
		N_("Girl");     // 070
		N_("Ox");       // 071
		N_("Heart");    // 072
		N_("Room");     // 073
		N_("Spring");   // 074
		N_("Establishment");    // 075
		N_("Flail");    // 076
		N_("Spear");    // 077
		N_("Right Flag");       // 078
		N_("Left Flag");        // 079
		N_("Drumstick");        // 080
		N_("Bond");     // 081
		N_("Woman's Bed");      // 082
		N_("Western Door");     // 083
		N_("Eastern Door");     // 084
		N_("Farmland"); // 085
		N_("Star");     // 086
		N_("Ghosts");   // 087
		N_("Xuanyuan"); // 088
		N_("Tripod");   // 089
		N_("Neck");     // 090
		N_("Zaofu");    // 091
		N_("Market Officer");   // 092
		N_("Banner of Three Stars");    // 093

		// Polynesian Constellations
		N_("Bailer");   // 001
		N_("Cat's Cradle");     // 002
		N_("Voice of Joy");     // 004
		N_("The Seven");        // 005
		N_("Maui's Fishhook");  // 006
		N_("Navigator's Triangle");     // 007
		N_("Kite of Kawelo");   // 008
		N_("Frigate Bird");     // 009
		N_("Cared for by Moon");        // 010
		N_("Dolphin");  // 011

		// Inuit Constellations
		_("Two Sunbeams");
		_("Two Placed Far Apart");
		_("Dogs");
		_("Collarbones");
		_("Lamp Stand");
		_("Caribou");
		_("Two in Front");
		_("Breastbone");
		_("Runners");
		_("Blubber Container");
		_("The One Behind");

		// Hindu constellations
		_("Sapt Rishi");
		_("Laghu Saptrishi");
		_("Kaalpurush");
		_("Mrgsirsa");
		_("Ardra");
		_("Pushya");
		_("Aslesha");
		_("Rohini");
		_("Magha");
		_("Purvaphalguni");
		_("Uttraphalguni");
		_("Hasta");
		_("Chitra");
		_("Swati");
		_("Vishakha");
		_("Anuradha");
		_("Jyeshtha");
		_("Mula");
		_("Purvasdha");
		_("Uttrasdha");
		_("Sravan");
		_("Danistha");
		_("Satbhisaj");
		_("Purvabhadrapad");
		_("Uttrabhadprad");
		_("Punarvasu");
		_("Revati");
		_("Ashwani");
		_("Bharani");
		_("Kritika");
		_("Shwan");

		// Lakota constellations
		_("Hand");
		_("Snake");
		_("Fireplace");
		_("Dipper");
		_("Race Track");
		_("Animal");
		_("Elk");
		_("Seven Little Girls");
		_("Dried Willow");
		_("Salamander");
		_("Turtle");
		_("Thunderbird");
		_("Bear's Lodge");

		// Navajo constellations
		_("Revolving Male");
		_("Revolving Female");
		_("Man with Feet Apart");
		_("Lizard");
		_("Dilyehe");
		_("First Big One");
		_("Rabbit Tracks");
		_("First Slim One");

		// Norse constellations
		_("Aurvandil's Toe");
		_("Wolf's Mouth");
		_("The Fishermen");
		_("Woman's Cart");
		_("Man's Cart");
		_("The Asar Battlefield");

		// Sami constellations
		_("Sarva the Elk");
		_("Favdna's Bow and Arrow");
		_("Galla's Sons");
		_("Sky Support");
		_("Favdna");
		_("The Runner");
		_("Morning Star");
		_("Pack of Dogs");
		_("Galla");
		_("The Ski Runners");


		// Western star names
		_("Acamar");
		_("Achernar");
		_("Acrab");
		_("Acrux");
		_("Acubens");
		_("Adhafera");
		_("Adhara");
		_("Adhil");
		_("Ain");
		_("Albali");
		_("Albireo");
		_("Alchiba");
		_("Alcor");
		_("Alcyone");
		_("Aldebaran");
		_("Alderamin");
		_("Alfirk");
		_("Algedi");
		_("Algenib");
		_("Algieba");
		_("Algol");
		_("Algorab");
		_("Alhena");
		_("Alioth");
		_("Alkaid");
		_("Alkalurops");
		_("Alkes");
		_("Almaak");
		_("Alnair");
		_("Alnasl");
		_("Alnath");
		_("Alnilam");
		_("Alnitak");
		_("Al Niyat");
		_("Alphard");
		_("Alphekka");
		_("Alpheratz");
		_("Alrakis");
		_("Alrescha");
		_("Alshain");
		_("Altair");
		_("Altais");
		_("Alterf");
		_("Aludra");
		_("Alula Australis");
		_("Alula Borealis");
		_("Alya");
		_("Ancha");
		_("Ankaa");
		_("Antares");
		_("Arcturus");
		_("Arkab");
		_("Arneb");
		_("Ascella");
		_("Asellus Australis");
		_("Asellus Borealis");
		_("Aspidiske");
		_("Asterope");
		_("Atik");
		_("Atlas");
		_("Atria");
		_("Avior");
		_("Azelfafage");
		_("Azha");
		_("Babcock's Star");
		_("Barnard's Star");
		_("Baten Kaitos");
		_("Beid");
		_("Bellatrix");
		_("Bernes 135");
		_("Betelgeuse");
		_("Biham");
		_("Botein");
		_("Campbell's Star");
		_("Canopus");
		_("Capella");
		_("Caph");
		_("Castor");
		_("Cebalrai");
		_("Celaeno");
		_("Chara");
		_("Chertan");
		_("Cor Caroli");
		_("Cujam");
		_("Cursa");
		_("Dabih");
		_("Deneb");
		_("Deneb Algedi");
		_("Denebola");
		_("Diphda");
		_("Dschubba");
		_("Dubhe");
		_("Edasich");
		_("Electra");
		_("Enif");
		_("Errai");
		_("Etamin");
		_("Fomalhaut");
		_("Furud");
		_("Gacrux");
		_("Giausar");
		_("Gienah");
		_("Girtab");
		_("Gomeisa");
		_("Grumium");
		_("Hadar");
		_("Hamal");
		_("Homan");
		_("Izar");
		_("Kapteyn's Star");
		_("Kaus Australis");
		_("Kaus Borealis");
		_("Kaus Media");
		_("Keid");
		_("Kitalpha");
		_("Kocab");
		_("Kornephoros");
		_("Kruger 60");
		_("Kurhah");
		_("Lesath");
		_("Luyten's Star");
		_("Maasym");
		_("Maia");
		_("Marfik");
		_("Markab");
		_("Marsic");
		_("Matar");
		_("Mebsuta");
		_("Megrez");
		_("Meissa");
		_("Mekbuda");
		_("Menkalinan");
		_("Menkar");
		_("Menkent");
		_("Menkib");
		_("Merak");
		_("Merga");
		_("Merope");
		_("Mesarthim");
		_("Miaplacidus");
		_("Mimosa");
		_("Mintaka");
		_("Mira");
		_("Mirach");
		_("Mirphak");
		_("Mirzam");
		_("Mizar");
		_("Mothallah");
		_("Muliphein");
		_("Muphrid");
		_("Muscida");
		_("Naos");
		_("Nashira");
		_("Nekkar");
		_("Nihal");
		_("Nunki");
		_("Nusakan");
		_("Peacock");
		_("Phact");
		_("Phad");
		_("Pherkad");
		_("Pleione");
		_("Polaris");
		_("Pollux");
		_("Porrima");
		_("Procyon");
		_("Propus");
		_("Proxima");
		_("Rasalas");
		_("Rasalgethi");
		_("Rasalhague");
		_("Rastaban");
		_("Red Rectangle");
		_("Regor");
		_("Regulus");
		_("Rigel");
		_("Rigil Kent");
		_("Rotanev");
		_("Ruchbah");
		_("Rukbat");
		_("Sabik");
		_("Sadachbia");
		_("Sadalbari");
		_("Sadalmelik");
		_("Sadalsuud");
		_("Sadr");
		_("Saiph");
		_("Seginus");
		_("Sham");
		_("Shaula");
		_("Sheat");
		_("Shedir");
		_("Sheliak");
		_("Sheratan");
		_("Sirius");
		_("Situla");
		_("Skat");
		_("Spica");
		_("Sualocin");
		_("Subra");
		_("Suhail");
		_("Sulafat");
		_("Syrma");
		_("Talitha");
		_("Tania Australis");
		_("Tania Borealis");
		_("Tarazed");
		_("Taygeta");
		_("Tegmine");
		_("Tejat");
		_("The Garnet Star");
		_("Thuban");
		_("Unukalhai");
		_("Van Maanen 2");
		_("Vega");
		_("Vindemiatrix");
		_("Wasat");
		_("Wazn");
		_("Wezen");
		_("Yed Posterior");
		_("Yed Prior");
		_("Yildun");
		_("Zaniah");
		_("Zaurak");
		_("Zavijava");
		_("Zibal");
		_("Zosma");
		_("Zubenelgenubi");
		_("Zubeneschamali");

		// Hindu star names
		_("Abhijeet");
		_("Agni");
		_("Angira");
		_("Anuradha");
		_("Ardra");
		_("Ashwini");
		_("Aslesha");
		_("Atri");
		_("Augutsya");
		_("Bharni");
		_("Brahamhridya");
		_("Chitra");
		_("Dhanishtha-1");
		_("Dhanishtha-2");
		_("Dhruv");
		_("Hasta");
		_("Jyeshtha");
		_("Kratu");
		_("Kritika");
		_("Lubhdak");
		_("Magha");
		_("Marichi");
		_("Mrigsirsa");
		_("Mula");
		_("Prajapati");
		_("Pulaha");
		_("Pulastya");
		_("Punarsvasu-2");
		_("Punarvasu-1");
		_("Punarvasu-2");
		_("Purva Bhadrapad-1");
		_("Purva Bhadrapad-2");
		_("Purvaphalguni-1");
		_("Purvaphalguni-2");
		_("Purvasadha-1");
		_("Pushya");
		_("Rohini");
		_("Shravan");
		_("Swati");
		_("Uttarabhadrapad-1");
		_("Uttarabhadrapad-2");
		_("UttraPhalguni-1");
		_("Uttraphalguni-2");
		_("Uttrasadha");
		_("Vashista");
		_("Vishakha");

		// Norse star names
		_("Day star");
		_("Guide star");
		_("South star");

		// Polynesian star names
		_("A'a");
		_("Hawaiki");
		_("Hiki-analia");
		_("Hiku-ha");
		_("Hiku-kahi");
		_("Hiku-kolu");
		_("Hiku-lima");
		_("Hiku-lua");
		_("Hiku-ono");
		_("Hiku-pau");
		_("Hokule'a");
		_("Hokulei");
		_("Hokupa'a");
		_("Hoku'ula");
		_("Holopuni");
		_("Humu");
		_("Ka-maile-hope");
		_("Ka-maile-mua");
		_("Ka_Maka");
		_("Kaulia");
		_("Kaulua-koko");
		_("Ke_ali'i_o_kona_i_ka_lewa");
		_("Keoe");
		_("Lehua-Kona");
		_("Mole_Honua");
		_("Nana-hope");
		_("Nana-mua");
		_("Puana");
		_("Puana-kau");
		_("Pu'uhonua");


		// Nebulae
		N_("M31");
		N_("M42/M43");
		N_("M45");
		N_("Einstein Cross");
		N_("SN Remnant HH30");
		N_("Hubble Deep Field");
		N_("Southern Ring Nebula");
		N_("Ring Nebula");
		N_("Supernova Remnant");
		N_("Tarantula Nebula");
		N_("Spiral Galaxy Coma");
		N_("Merging Galaxies");
		N_("Keyhole Nebula");
		N_("Reflection Nebula Orion");
		N_("Planetary Nebula Aquila");
		N_("Spirograph Nebula");
		N_("Stars Forming SMC");
		N_("Interacting Galaxies");
		N_("Hubble X");
		N_("Ant Nebula");
		N_("Omega Centauri");
		N_("Hubble V");
		N_("Thackerays Globules");
		N_("Face On Galaxy");
		N_("Galaxy spiral arms");
		N_("H II LMC");
		N_("Retina Nebula");
		N_("Cassiopeia A");
		N_("Little Ghost Nebula");
		N_("Double Bubble");
		N_("Dwarf irregular galaxy");
		N_("Egg Nebula");
		N_("V838 Monocerotis");
		N_("NGC1275 PerseusA");
		N_("Pencil Nebula");
		N_("LMC Supernova Remnant");
		N_("Globular Cluster Ara");
		N_("M104 Sombrero Galaxy");
		N_("Stars Forming M33");
		N_("M64 Black Eye Galaxy");
		N_("Hubble Ultra Deep Field");
		N_("Spiral Galaxy Leo");
		N_("Rosetta Nebula");
		N_("IC434 &amp; Horse Head Nebula");
		N_("NGC253");
		N_("Chi &amp; h Per");
		N_("California Nebula");
		N_("NGC6946");
		N_("M1");
		N_("M2");
		N_("M3");
		N_("M4");
		N_("M5");
		N_("M6");
		N_("M7");
		N_("M8");
		N_("M9");
		N_("M10");
		N_("M11");
		N_("M12");
		N_("M13");
		N_("M15");
		N_("M16");
		N_("M17");
		N_("M20");
		N_("M22");
		N_("M27");
		N_("M33");
		N_("M34");
		N_("M36");
		N_("M37");
		N_("M38");
		N_("M44");
		N_("M46");
		N_("M49");
		N_("M51");
		N_("M53");
		N_("M54");
		N_("M58");
		N_("M59");
		N_("M60");
		N_("M61");
		N_("M63");
		N_("M65");
		N_("M66");
		N_("M74");
		N_("M76");
		N_("M78");
		N_("M81");
		N_("M82");
		N_("M83");
		N_("M84");
		N_("M85");
		N_("M86");
		N_("M87");
		N_("M89");
		N_("M90");
		N_("M91");
		N_("M92");
		N_("M94");
		N_("M95");
		N_("M96");
		N_("M97");
		N_("M98");
		N_("M99");
		N_("M100");
		N_("M101");
		N_("M105");
		N_("M106");
		N_("M108");
		N_("M109");


		// TUI script message
		N_("Select and exit to run.");

		// TUI Actions
		N_("Do");
		N_("Done");
		N_("Are you sure ?");

	}
}
