module Prelude(RealFloat(..)) where

import PrimDecodeFloat
import PrimEncodeFloat
import CRealFloat

-- WARNING 32bit IEEE float

instance  RealFloat Float  where
    floatRadix _  = 2          -- FLT_RADIX
    floatDigits _ = 24         -- FLT_DIGITS
    floatRange _  = (negate 148,128) -- (FLT_MINEXP, FLT_MAXEXP)
    decodeFloat x = primDecodeFloat x
    encodeFloat x y = primEncodeFloat x y

    -- TODO
    isNaN x 	     = cFIsNaN x
    isInfinite x     = not (cFIsFinite x)
    isDenormalized x = not (cFIsNormal x)
    isNegativeZero x = cFIsNeg x && (x==0.0)
    isIEEE x         = True

foreign import noproto "math.h isnan"    cFIsNaN    :: Float -> Bool
foreign import noproto "math.h isfinite" cFIsFinite :: Float -> Bool
foreign import noproto "math.h isnormal" cFIsNormal :: Float -> Bool
foreign import noproto "math.h signbit"  cFIsNeg    :: Float -> Bool
