/*------------------------------------------------------------------------*/
/**
 * @file	NewtCore.h
 * @brief   必須ヘッダをインクルード
 *
 * @author  M.Nukui
 * @date	2004-01-25
 *
 * Copyright (C) 2003-2004 M.Nukui All rights reserved.
 */


/** @mainpage NEWT/0
 *
 *	NEWT/0 は Apple の PDA “Newton” のシステム言語 NewtonScript を独自実装したプロトタイプ指向言語です。
 *
 *	@section feature 特徴
 *
 *	NEWT/0 は以下のような特徴を持っています:
 *	- NewtonScriptインタープリタ
 *	- プロトタイプ指向
 *	- バイトコードコンパイル+VM実行
 *	- 独自拡張
 *	- コマンド実行
 *	- オープンソースライセンス
 *
 */

#ifndef	NEWTCORE_H
#define	NEWTCORE_H


/* ヘッダファイル */
#include "NewtType.h"
#include "NewtErrs.h"
#include "NewtFns.h"
#include "NewtEnv.h"
#include "NewtObj.h"


#endif /* NEWTCORE_H */
