/*
                                  NETWOX
                             Network toolbox
                Copyright(c) 1999-2005 Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
                   http://laurentconstantin.free.fr/
                   http://membres.lycos.fr/lauconstantin/
  [my current email address is on the web servers]

                                  -----
  This file is part of Netwox.

  Netwox is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  version 2 as published by the Free Software Foundation.

  Netwox is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details (http://www.gnu.org/).

------------------------------------------------------------------------
*/

/*-------------------------------------------------------------*/
#include "../netwox.h"

/*-------------------------------------------------------------*/
netwib_conststring t000212_description[] = {
  "This tool indicates where web spider stored an url.",
  NETWOX_DESC_toolpriv_none,
  NULL
};
netwox_toolarg t000212_args[] = {
  NETWOX_TOOLARG_REQ_BUF_FILE_RD('f', "conffile", "configuration file", NULL),
  NETWOX_TOOLARG_REQ_BUF_URI('u', "url", "url to check", NULL),
  NETWOX_TOOLARG_END
};
netwox_tooltreenodetype t000212_nodes[] = {
  NETWOX_TOOLTREENODETYPE_CLIENT_TCP_HTTP_SPIDER,
  NETWOX_TOOLTREENODETYPE_END
};
netwox_tool_info t000212_info = {
  "Web spider : indicates where an url is stored",
  t000212_description,
  NULL,
  t000212_args,
  t000212_nodes,
};

/*-------------------------------------------------------------*/
netwib_err t000212_core(int argc, char *argv[])
{
  netwox_arg *parg;
  netwib_buf conffile, url, localfilename;
  netwox_webspider webspider;
  netwib_bool exists;

  /* obtain parameters */
  netwib_er(netwox_arg_init(argc, argv, &t000212_info, &parg));
  netwib_er(netwox_arg_buf(parg, 'f', &conffile));
  netwib_er(netwox_arg_buf(parg, 'u', &url));

  /* spider */
  netwib_er(netwox_webspider_init(&webspider));
  netwib_er(netwox_webspidercf_read(&conffile, &webspider));
  netwib_er(netwib_buf_init_mallocdefault(&localfilename));
  netwib_er(netwox_urllocal_exists(&webspider.localrootdir, &url,
                                   webspider.maxsegmentlen,
                                   webspider.maxtotallen, &exists,
                                   &localfilename));
  if (exists) {
    netwib_er(netwib_fmt_display("%{buf}\n", &localfilename));
  } else {
    netwib_er(netwib_fmt_display("Not downloaded\n"));
  }
  netwib_er(netwib_buf_close(&localfilename));
  netwib_er(netwox_webspider_close(&webspider));

  /* close */
  netwib_er(netwox_arg_close(&parg));
  return(NETWIB_ERR_OK);
}
