
/*-------------------------------------------------------------*/
/* NETWOX_SMBCMD_TYPE_TRANSACTION_R */

/*-------------------------------------------------------------*/
typedef struct {
  netwib_bool isunicode;
  netwib_uint8 setupcount;
  netwib_uint16 setup[NETWOX_SMBCMD_TRANSACTION_SETUP_MAX];
  netwib_buf para;
  netwib_buf data;
} netwox_smbcmdtscrstorage;
typedef const netwox_smbcmdtscrstorage netwox_constsmbcmdtscrstorage;
/* buffers have CANALLOC flag */
netwib_err netwox_smbcmdtscrstorage_init(netwib_bool isunicode,
                                         netwox_smbcmdtscrstorage *pstorage);
/* buffers are closed if they were allocated */
netwib_err netwox_smbcmdtscrstorage_close(netwox_smbcmdtscrstorage *pstorage);
/*
   - if smbcmd contains all the data:
       - pneedmoremsg is set to false
       - buf_init_ext_buf is used (so don't close smbcmd after this function)
   - else:
       - pneedmoremsg is set to true
       - buf_append_buf is used (so buffers are allocated)
*/
netwib_err netwox_smbcmdtscrstorage_append_smbcmd(netwox_constsmbcmd *psmbcmd,
                                          netwox_smbcmdtscrstorage *pstorage,
                                                  netwib_bool *pneedmoremsg);
/* Set offset to 0 before first call.
   This function only decodes setup/para/data using buf_init_ext (so
   don't close storage after this function). Other values must be set by user.
*/
netwib_err netwox_smbcmdtscrstorage_decode_smbcmd(netwox_constsmbcmdtscrstorage *pstorage,
                                                  netwib_uint32 *poffset,
                                                  netwib_uint32 maxsize,
                                                  netwox_smbcmd *psmbcmd,
                                                  netwib_bool *pneedmoremsg);

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_SMBCMDTSCR_TYPE_UNKNOWN = 0,
  NETWOX_SMBCMDTSCR_TYPE_NETSHAREENUM
} netwox_smbcmdtscr_type;

/*-------------------------------------------------------------*/
typedef struct {
  netwox_smbcmdcmn_data name;
  netwox_smbcmdcmn_sharetype sharetype;
  netwib_uint16 unknown;
  netwox_smbcmdcmn_data comment;
} netwox_smbcmdtscr_netshareenum_item;
netwib_err netwox_smbcmdtscr_netshareenum_item_init(netwox_smbcmdtscr_netshareenum_item *pitem);
netwib_err netwox_smbcmdtscr_netshareenum_item_setdefault(netwox_smbcmdtscr_netshareenum_item *pitem);
netwib_err netwox_smbcmdtscr_netshareenum_item_close(netwox_smbcmdtscr_netshareenum_item *pitem);
typedef struct {
  netwib_uint16 status; /* 0 == success */
  netwib_uint16 totalshares; /* because they might not be all in this tsc */
  netwib_array shares;
} netwox_smbcmdtscr_netshareenum;

/*-------------------------------------------------------------*/
typedef struct {
  netwox_smbcmdtscr_type type;
  union {
    netwox_smbcmdtscr_netshareenum netshareenum;
  } value;
} netwox_smbcmdtscr;
typedef const netwox_smbcmdtscr netwox_constsmbcmdtscr;

/*-------------------------------------------------------------*/
typedef struct {
  netwox_smbcmdtscr_type type;
  union {
    struct {
      netwib_uint32 sharenamelen;
    } netshareenum;
  } value;
} netwox_smbcmdtscrfmt;
typedef const netwox_smbcmdtscrfmt netwox_constsmbcmdtscrfmt;
netwib_err netwox_smbcmdtscrfmt_init_smbcmdtscq(netwox_constsmbcmdtscq *psmbcmdtscq,
                                                netwox_smbcmdtscrfmt *psmbcmdtscrfmt);

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscr_init(netwox_smbcmdtscr *psmbcmdtscr);
netwib_err netwox_smbcmdtscr_selecttype(netwox_smbcmdtscr *psmbcmdtscr,
                                        netwox_smbcmdtscr_type type);
netwib_err netwox_smbcmdtscr_setdefault(netwox_smbcmdtscr *psmbcmdtscr);
netwib_err netwox_smbcmdtscr_close(netwox_smbcmdtscr *psmbcmdtscr);

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscr_encode_storager(netwox_constsmbcmdtscrstorage *pstorage,
                                    netwox_constsmbcmdtscrfmt *psmbcmdtscrfmt,
                                    netwox_smbcmdtscr *psmbcmdtscr);
netwib_err netwox_smbcmdtscr_decode_storager(netwox_constsmbcmdtscr *psmbcmdtscr,
                                    netwox_constsmbcmdtscrfmt *psmbcmdtscrfmt,
                                    netwox_smbcmdtscrstorage *pstorage);

/*-------------------------------------------------------------*/
netwib_err netwox_smbcmdtscr_show(netwox_constsmbcmdtscr *psmbcmdtscr,
                                  netwib_buf *pbuf);
