/* This file is part of Netwib.
*/

/*-------------------------------------------------------------*/
static void netwib_debug_sighdl_report(int num)
{
  netwib_err ret;

#if NETWIB_DEBUG_SIGHDL_REPORT == 1
  puts("Signal received (might cause deadlock...)");
  ret = netwib_debug_leak_report();
  if (ret != NETWIB_ERR_OK) {
    netwib_priv_notify_err(NETWIB_PRIV_NOTIFYTYPE_WARNING, ret);
  }
  ret = netwib_debug_memcorrupt_check_all();
  if (ret != NETWIB_ERR_OK) {
    netwib_priv_notify_err(NETWIB_PRIV_NOTIFYTYPE_WARNING, ret);
  }
  ret = netwib_debug_fdopen_check();
  if (ret != NETWIB_ERR_OK) {
    netwib_priv_notify_err(NETWIB_PRIV_NOTIFYTYPE_WARNING, ret);
  }
#else
  puts("Signal received");
  puts("Leak report currently deactivated");
#endif

  if (num == SIGINT || num == SIGTERM) {
    raise(SIGKILL);
  }
  return;
  ret = NETWIB_ERR_OK;
}

/*-------------------------------------------------------------*/
netwib_err netwib_debug_sighdl_init(void)
{

  /* set signal handlers */
  signal(SIGINT, netwib_debug_sighdl_report);
  signal(SIGTERM, netwib_debug_sighdl_report);
  /* we could also set SIGUSR1/USR2, but LinuxThread implementation
     on kernels < 2.2 use them (documented in LinuxThread FAQ). */

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwib_debug_sighdl_close(void)
{

  /* set signal handlers */
  signal(SIGINT, SIG_DFL);
  signal(SIGTERM, SIG_DFL);

  return(NETWIB_ERR_OK);
}
