/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

/* This class stores informations about which user is in which channel */

#ifndef _USERDB_H_
#define _USERDB_H_ 1

#include "config.h"
#include "classes.h"
#include "functions.h"

class UserDB {
private:
	Parameter ** users; /* pointer to a pointer array. this pointer array points to an object of the class 'Parameter' for each Channel we are in */
	char channel[CHANNELS_MAX][CHANNELS_NAME_LEN]; /* notice: channelnames are stores in lowercase format, but the usernames in the parameter class above are store how they are */
	int Get_Index_for_Channel(char * tmp_channel); /* ret: -1 = no such channel; 0-xx index */
	void Reset_UserDB(int index); /* for example: if you leave a channel */
public:
	UserDB(void);
	~UserDB(void);
	void Reset_All_UserDB(void);           /* for example: if you reconnect       */
	void Reset_UserDB(char * tmp_channel); /* for example: if you leave a channel */
	void Init_UserDB(char * new_channel);  /* if you join a channel */
	void Add_User(char * new_user, char * tmp_channel); /* a user will only be added if he isnt in this channel */
	void Remove_User_from_Channel(char * tmp_user, char * tmp_channel); /* if we only know the channelname */
	void Remove_User_from_Channel(int user_index, char * tmp_channel); /* if we know the index number */
	void Remove_User_from_all_Channels(char * tmp_user);
	int Is_User_in_Channel(char * tmp_user, char * tmp_channel); /* ret: -1 = no, this user is not in this Channel; 0-xxxx = yep, he is here, and his index is the return value */
	int Get_Num_Users_in_Channel(char * tmp_channel);
	void ListUsersToScreen(char * search_pattern);
};

#endif
