/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#define _SIGNALS_CC_
#include <signal.h>
#include "signals.h"

void sig_handler(int signum)
{
	if(signum == SIGINT) return;
	if(signum == SIGHUP) return;
	if(signum == SIGALRM) return;
	if(signum == SIGTERM) return;
	if(signum == SIGUSR1) return;
	if(signum == SIGUSR2) return;
	if(signum == SIGSTOP) return;
	if(signum == SIGCONT) return;
	if(signum == SIGTSTP) return;
	if(signum == SIGTTIN) return;
	if(signum == SIGTTOU) return;
	if(signum == SIGWINCH) Classes.Signals->on_sigwinch();
	return;
}

SigHandler::SigHandler(void)
{
	return;
}

SigHandler::~SigHandler(void)
{
	return;
}

void SigHandler::on_sigwinch(void)
{
	Classes.IrcScreen->MarktoRedrawScreen();
	return;
}

#undef _SIGNALS_CC_
