/*
 *      Code from:              Philipp Meinen
 *      Copyright (C):          2003-2004 Philipp Meinen
 *
 *      Email:                  lancelot@lancelot2k.dyndns.org
 *      Homepage:               http://lancelot2k.dyndns.org
 *      License:                GPL
 *                                                      */

#ifndef _FUNCTIONS_H_
#define _FUNCTIONS_H_ 1

#include "classes.h"
#include "config.h"

void usage(char * name);
struct from_config_file * get_config_file_settings(void);
void create_default_config(void);
//int write_config_file(struct from_config_file * settings); /* ret: 0 = error; 1 = OK */
void test_config_file(void);
void set_default_config(struct from_config_file * settings);
int num_lines(int text_len, int screen_len);
/* ret = the position in the given string where the 'count' 'search_char' has been found or -1 when there was nothing like that*/
int position_of_num_char(char * string, char search_char, int count); 
void print_version(void);
int search_next_num_char(char * string, char search_char, int count, int startposition); /* this function searches the next 'count' 'search_char' from the string 'string', begining from position 'startposition' in the given string; on succes, a position number is returned and on error -1 is returned */
int count_chars_from_pos_to_pos(char * string, char search_char, int startposition, int endposition); /* returns the number of 'search_char' which were found in 'string' beginning from 'startposition' and ending at the position 'endposition' or -1 on error. if 'endposition' is zero the hole 'string' will be scanned */
void string_tolower(char * string);
void string_toupper(char * string);
int CheckForInputData(void); /* ret: -1 = error; 0 = no new data; 1 = data on stdin; 2 = data on network */
void make_first_char_away(char * string); /* this function makes this string: "abcdefg" to this string: "bcdefg" */
void Bring_away_special_chars(char * string); /* function to bring a away terminal controll chars that I dont catch somewhere else */
int does_match(char * string, char * pattern); /* ret: 1=does match; 0=does not match  ;; my pseudo "grep" function. but it is enough for this irc client :p */
int does_match_case_insensitive(char * string, char * pattern); /* does the same as "does_match" but the case doesnt matter */
int have_to_call_connect(void); /* checks, if we have to connect to the irc-network: ret: 2 = imediately connect ; 1 = connect; 0 = dont connect */
void help_me(char * user_input); /* print help to the asked command */
void * nameresolv_wrapper(void * function);
int text_strlen(char * string); /* returns the real strlen of a text (without format informations) */

#endif
