/*

Copyright (C) 2000 - 2010 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <nd_gui.h>
#include <nd_tp.h>
#include <nd_trace_registry.h>

static void 
tp_sel_clr(LND_TracePart *tp)
{
  D_ENTER;
  nd_gui_list_unselect_all(tp->tpm->trace, FALSE);
  D_RETURN;
}


static void
tp_sel_all(LND_TracePart *tp)
{
  D_ENTER;
  nd_gui_list_select_all(tp->tpm->trace, FALSE);
  nd_trace_set_current_packet(tp->tpm->trace,
			      libnd_tpm_get_packets(tp->tpm));
  D_RETURN;
}


static void
tp_sel_del(LND_TracePart *tp)
{
  D_ENTER;
  nd_gui_num_packets_set();
  nd_gui_list_update(tp->tpm->trace);
  D_RETURN;
}


void
nd_tp_init(void)
{
  LND_TracePartObserver *ob;

  D_ENTER;

  if (! (ob = libnd_tp_observer_new()))
    {
      D(("Out of memory.\n"));
      D_RETURN;
    }

  ob->tp_sel_clr = tp_sel_clr;
  ob->tp_sel_all = tp_sel_all;
  ob->tp_sel_del = tp_sel_del;

  libnd_tp_add_observer(ob);

  D_RETURN;
}



/* Gtk idle handler for setting current packet */
static int
tp_set_current_packet_ih(gpointer data)
{
  ND_Trace      *trace_gui;
  LND_TracePart *tp = (LND_TracePart *) data;

  D_ENTER;

  if (!tp)
    D_RETURN_(FALSE);

  trace_gui = nd_trace_get(tp->tpm->trace);
  D_ASSERT_PTR(trace_gui);
  trace_gui->sel_handler = -1;

  nd_trace_set_current_packet(tp->tpm->trace, tp->sel.last);
  nd_gui_sync_edit_menu();

  D_RETURN_(FALSE);
}


void               
nd_tp_select_packet(LND_TracePart *tp, int index)
{
  ND_Trace      *trace_gui;

  libnd_tp_select_packet(tp, index);
  
  trace_gui = nd_trace_get(tp->tpm->trace);
  D_ASSERT_PTR(trace_gui);

  if (trace_gui->sel_handler < 0)
    trace_gui->sel_handler = gtk_idle_add(tp_set_current_packet_ih, tp);
}


void               
nd_tp_packet_insert_at_index(LND_TracePart *tp,
			     LND_Packet *packet,
			     int index)
{
  D_ENTER;

  if (!tp || !packet || index < 0)
    D_RETURN;

  nd_gui_list_insert_row(packet, index);
  
  if (tp->tpm->trace == nd_trace_registry_get_current())
    nd_gui_num_packets_set();

  D_RETURN;
}

