/*

Copyright (C) 2000 - 2003 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#ifndef __nd_tcp_h
#define __nd_tcp_h

#include <protocols/tcp/libnd_tcp.h>

#include <nd.h>
#include <nd_packet.h>
#include <nd_protocol.h>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

typedef enum {
  ND_TCP_STATE_NONE,
  ND_TCP_STATE_ONCE,
  ND_TCP_STATE_UPDATE_SINGLE,
  ND_TCP_STATE_UPDATE_ALL
} ND_TCPStateMode;

/* These are the implementations of ND_Protocol's callbacks: */
GtkWidget *nd_tcp_create_gui(LND_Trace *trace, LND_ProtoInfo *pinf);
void       nd_tcp_set_gui(const LND_Packet *packet, LND_ProtoInfo *pinf);

LND_Protocol *nd_tcp_get(void);
ND_Protocol  *nd_tcp_get_gui(void);

/* Helper functions to set a trace's GUI table to a packet's content: */
void  nd_tcp_set_gui_sport(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_dport(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_seq(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_ack(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_off(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_unused(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_flags(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_win(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_cksum(LND_ProtoInfo *pinf, struct ip *iphdr,
			   struct tcphdr *tcphdr, const LND_Packet *packet);
void  nd_tcp_set_gui_urg(LND_ProtoInfo *pinf, struct tcphdr *tcphdr);
void  nd_tcp_set_gui_options(LND_ProtoInfo *pinf, struct tcphdr *tcphdr, const LND_Packet *packet);

#endif
