// Code generated by metricgen; DO NOT EDIT.
// source: contexts.yaml

package contexts

import (
	"github.com/netdata/netdata/go/plugins/plugin/go.d/agent/module"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
	"strings"
)

// cleanLabelValue cleans a label value for use in instance/dimension IDs
func cleanLabelValue(value string) string {
	// Replace problematic characters
	r := strings.NewReplacer(
		" ", "_",
		".", "_",
		"-", "_",
		"/", "_",
		":", "_",
		"=", "_",
		",", "_",
		"(", "_",
		")", "_",
	)
	return strings.ToLower(r.Replace(value))
}

// EmptyLabels is used for contexts without labels
type EmptyLabels struct{}

// InstanceID for empty labels just returns the context name
func (EmptyLabels) InstanceID(contextName string) string {
	return contextName
}

// --- Applications ---

// ApplicationsRequestsValues defines the type-safe values for Applications.Requests context
type ApplicationsRequestsValues struct {
	Requests int64
}

// ApplicationsRequestsContext provides type-safe operations for Applications.Requests context
type ApplicationsRequestsContext struct {
	framework.Context[ApplicationsLabels]
}

// Set provides type-safe dimension setting for Applications.Requests context
func (c ApplicationsRequestsContext) Set(state *framework.CollectorState, labels ApplicationsLabels, values ApplicationsRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests": values.Requests,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ApplicationsRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels ApplicationsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ApplicationsResponseTimeValues defines the type-safe values for Applications.ResponseTime context
type ApplicationsResponseTimeValues struct {
	Response_time int64
}

// ApplicationsResponseTimeContext provides type-safe operations for Applications.ResponseTime context
type ApplicationsResponseTimeContext struct {
	framework.Context[ApplicationsLabels]
}

// Set provides type-safe dimension setting for Applications.ResponseTime context
func (c ApplicationsResponseTimeContext) Set(state *framework.CollectorState, labels ApplicationsLabels, values ApplicationsResponseTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"response_time": values.Response_time,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ApplicationsResponseTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ApplicationsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ApplicationsSessionsActiveValues defines the type-safe values for Applications.SessionsActive context
type ApplicationsSessionsActiveValues struct {
	Active int64
}

// ApplicationsSessionsActiveContext provides type-safe operations for Applications.SessionsActive context
type ApplicationsSessionsActiveContext struct {
	framework.Context[ApplicationsLabels]
}

// Set provides type-safe dimension setting for Applications.SessionsActive context
func (c ApplicationsSessionsActiveContext) Set(state *framework.CollectorState, labels ApplicationsLabels, values ApplicationsSessionsActiveValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ApplicationsSessionsActiveContext) SetUpdateEvery(state *framework.CollectorState, labels ApplicationsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ApplicationsSessionsLiveValues defines the type-safe values for Applications.SessionsLive context
type ApplicationsSessionsLiveValues struct {
	Live int64
}

// ApplicationsSessionsLiveContext provides type-safe operations for Applications.SessionsLive context
type ApplicationsSessionsLiveContext struct {
	framework.Context[ApplicationsLabels]
}

// Set provides type-safe dimension setting for Applications.SessionsLive context
func (c ApplicationsSessionsLiveContext) Set(state *framework.CollectorState, labels ApplicationsLabels, values ApplicationsSessionsLiveValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"live": values.Live,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ApplicationsSessionsLiveContext) SetUpdateEvery(state *framework.CollectorState, labels ApplicationsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ApplicationsSessionEventsValues defines the type-safe values for Applications.SessionEvents context
type ApplicationsSessionEventsValues struct {
	Creates     int64
	Invalidates int64
}

// ApplicationsSessionEventsContext provides type-safe operations for Applications.SessionEvents context
type ApplicationsSessionEventsContext struct {
	framework.Context[ApplicationsLabels]
}

// Set provides type-safe dimension setting for Applications.SessionEvents context
func (c ApplicationsSessionEventsContext) Set(state *framework.CollectorState, labels ApplicationsLabels, values ApplicationsSessionEventsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"creates":     values.Creates,
		"invalidates": values.Invalidates,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ApplicationsSessionEventsContext) SetUpdateEvery(state *framework.CollectorState, labels ApplicationsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ApplicationsTransactionsValues defines the type-safe values for Applications.Transactions context
type ApplicationsTransactionsValues struct {
	Committed  int64
	Rolledback int64
}

// ApplicationsTransactionsContext provides type-safe operations for Applications.Transactions context
type ApplicationsTransactionsContext struct {
	framework.Context[ApplicationsLabels]
}

// Set provides type-safe dimension setting for Applications.Transactions context
func (c ApplicationsTransactionsContext) Set(state *framework.CollectorState, labels ApplicationsLabels, values ApplicationsTransactionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"committed":  values.Committed,
		"rolledback": values.Rolledback,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ApplicationsTransactionsContext) SetUpdateEvery(state *framework.CollectorState, labels ApplicationsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ApplicationsLabels defines the required labels for Applications contexts
type ApplicationsLabels struct {
	Application string
	Module      string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ApplicationsLabels) InstanceID(contextName string) string {
	// Label order from YAML: application, module
	return contextName + "." + cleanLabelValue(l.Application) + "_" + cleanLabelValue(l.Module)
}

// Applications contains all metric contexts for Applications
var Applications = struct {
	Requests       ApplicationsRequestsContext
	ResponseTime   ApplicationsResponseTimeContext
	SessionsActive ApplicationsSessionsActiveContext
	SessionsLive   ApplicationsSessionsLiveContext
	SessionEvents  ApplicationsSessionEventsContext
	Transactions   ApplicationsTransactionsContext
}{
	Requests: ApplicationsRequestsContext{
		Context: framework.Context[ApplicationsLabels]{
			Name:        "websphere_jmx.app_requests",
			Family:      "workloads/applications",
			Title:       "Application Requests",
			Units:       "requests",
			Type:        module.Line,
			Priority:    801,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application",
				"module",
			},
		},
	},
	ResponseTime: ApplicationsResponseTimeContext{
		Context: framework.Context[ApplicationsLabels]{
			Name:        "websphere_jmx.app_response_time",
			Family:      "workloads/applications",
			Title:       "Application Response Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    802,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "response_time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application",
				"module",
			},
		},
	},
	SessionsActive: ApplicationsSessionsActiveContext{
		Context: framework.Context[ApplicationsLabels]{
			Name:        "websphere_jmx.app_sessions_active",
			Family:      "workloads/applications",
			Title:       "Active Sessions",
			Units:       "sessions",
			Type:        module.Line,
			Priority:    803,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application",
				"module",
			},
		},
	},
	SessionsLive: ApplicationsSessionsLiveContext{
		Context: framework.Context[ApplicationsLabels]{
			Name:        "websphere_jmx.app_sessions_live",
			Family:      "workloads/applications",
			Title:       "Live Sessions",
			Units:       "sessions",
			Type:        module.Line,
			Priority:    804,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "live",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application",
				"module",
			},
		},
	},
	SessionEvents: ApplicationsSessionEventsContext{
		Context: framework.Context[ApplicationsLabels]{
			Name:        "websphere_jmx.app_session_events",
			Family:      "workloads/applications",
			Title:       "Session Events",
			Units:       "sessions",
			Type:        module.Stacked,
			Priority:    805,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "creates",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "invalidates",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application",
				"module",
			},
		},
	},
	Transactions: ApplicationsTransactionsContext{
		Context: framework.Context[ApplicationsLabels]{
			Name:        "websphere_jmx.app_transactions",
			Family:      "workloads/applications",
			Title:       "Application Transactions",
			Units:       "transactions",
			Type:        module.Line,
			Priority:    806,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "committed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "rolledback",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"application",
				"module",
			},
		},
	},
}

// --- JCA ---

// JCAPoolSizeValues defines the type-safe values for JCA.PoolSize context
type JCAPoolSizeValues struct {
	Size int64
}

// JCAPoolSizeContext provides type-safe operations for JCA.PoolSize context
type JCAPoolSizeContext struct {
	framework.Context[JCALabels]
}

// Set provides type-safe dimension setting for JCA.PoolSize context
func (c JCAPoolSizeContext) Set(state *framework.CollectorState, labels JCALabels, values JCAPoolSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"size": values.Size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAPoolSizeContext) SetUpdateEvery(state *framework.CollectorState, labels JCALabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAPoolUsageValues defines the type-safe values for JCA.PoolUsage context
type JCAPoolUsageValues struct {
	Active int64
	Free   int64
}

// JCAPoolUsageContext provides type-safe operations for JCA.PoolUsage context
type JCAPoolUsageContext struct {
	framework.Context[JCALabels]
}

// Set provides type-safe dimension setting for JCA.PoolUsage context
func (c JCAPoolUsageContext) Set(state *framework.CollectorState, labels JCALabels, values JCAPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
		"free":   values.Free,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels JCALabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAWaitTimeValues defines the type-safe values for JCA.WaitTime context
type JCAWaitTimeValues struct {
	Wait int64
}

// JCAWaitTimeContext provides type-safe operations for JCA.WaitTime context
type JCAWaitTimeContext struct {
	framework.Context[JCALabels]
}

// Set provides type-safe dimension setting for JCA.WaitTime context
func (c JCAWaitTimeContext) Set(state *framework.CollectorState, labels JCALabels, values JCAWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"wait": values.Wait,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels JCALabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAUseTimeValues defines the type-safe values for JCA.UseTime context
type JCAUseTimeValues struct {
	Use int64
}

// JCAUseTimeContext provides type-safe operations for JCA.UseTime context
type JCAUseTimeContext struct {
	framework.Context[JCALabels]
}

// Set provides type-safe dimension setting for JCA.UseTime context
func (c JCAUseTimeContext) Set(state *framework.CollectorState, labels JCALabels, values JCAUseTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"use": values.Use,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAUseTimeContext) SetUpdateEvery(state *framework.CollectorState, labels JCALabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAConnectionsTotalsValues defines the type-safe values for JCA.ConnectionsTotals context
type JCAConnectionsTotalsValues struct {
	Created   int64
	Destroyed int64
}

// JCAConnectionsTotalsContext provides type-safe operations for JCA.ConnectionsTotals context
type JCAConnectionsTotalsContext struct {
	framework.Context[JCALabels]
}

// Set provides type-safe dimension setting for JCA.ConnectionsTotals context
func (c JCAConnectionsTotalsContext) Set(state *framework.CollectorState, labels JCALabels, values JCAConnectionsTotalsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"created":   values.Created,
		"destroyed": values.Destroyed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAConnectionsTotalsContext) SetUpdateEvery(state *framework.CollectorState, labels JCALabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCAWaitingThreadsValues defines the type-safe values for JCA.WaitingThreads context
type JCAWaitingThreadsValues struct {
	Waiting int64
}

// JCAWaitingThreadsContext provides type-safe operations for JCA.WaitingThreads context
type JCAWaitingThreadsContext struct {
	framework.Context[JCALabels]
}

// Set provides type-safe dimension setting for JCA.WaitingThreads context
func (c JCAWaitingThreadsContext) Set(state *framework.CollectorState, labels JCALabels, values JCAWaitingThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"waiting": values.Waiting,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JCAWaitingThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels JCALabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JCALabels defines the required labels for JCA contexts
type JCALabels struct {
	Pool string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JCALabels) InstanceID(contextName string) string {
	// Label order from YAML: pool
	return contextName + "." + cleanLabelValue(l.Pool)
}

// JCA contains all metric contexts for JCA
var JCA = struct {
	PoolSize          JCAPoolSizeContext
	PoolUsage         JCAPoolUsageContext
	WaitTime          JCAWaitTimeContext
	UseTime           JCAUseTimeContext
	ConnectionsTotals JCAConnectionsTotalsContext
	WaitingThreads    JCAWaitingThreadsContext
}{
	PoolSize: JCAPoolSizeContext{
		Context: framework.Context[JCALabels]{
			Name:        "websphere_jmx.jca_pool_size",
			Family:      "workloads/jca",
			Title:       "JCA Pool Size",
			Units:       "connections",
			Type:        module.Line,
			Priority:    651,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	PoolUsage: JCAPoolUsageContext{
		Context: framework.Context[JCALabels]{
			Name:        "websphere_jmx.jca_pool_usage",
			Family:      "workloads/jca",
			Title:       "JCA Pool Usage",
			Units:       "connections",
			Type:        module.Stacked,
			Priority:    652,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	WaitTime: JCAWaitTimeContext{
		Context: framework.Context[JCALabels]{
			Name:        "websphere_jmx.jca_pool_wait_time",
			Family:      "workloads/jca",
			Title:       "JCA Average Wait Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    653,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "wait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	UseTime: JCAUseTimeContext{
		Context: framework.Context[JCALabels]{
			Name:        "websphere_jmx.jca_pool_use_time",
			Family:      "workloads/jca",
			Title:       "JCA Average Use Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    654,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "use",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	ConnectionsTotals: JCAConnectionsTotalsContext{
		Context: framework.Context[JCALabels]{
			Name:        "websphere_jmx.jca_pool_connections",
			Family:      "workloads/jca",
			Title:       "JCA Connections Totals",
			Units:       "connections",
			Type:        module.Line,
			Priority:    655,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "created",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "destroyed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	WaitingThreads: JCAWaitingThreadsContext{
		Context: framework.Context[JCALabels]{
			Name:        "websphere_jmx.jca_pool_waiting_threads",
			Family:      "workloads/jca",
			Title:       "JCA Waiting Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    656,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "waiting",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
}

// --- JDBC ---

// JDBCPoolSizeValues defines the type-safe values for JDBC.PoolSize context
type JDBCPoolSizeValues struct {
	Size int64
}

// JDBCPoolSizeContext provides type-safe operations for JDBC.PoolSize context
type JDBCPoolSizeContext struct {
	framework.Context[JDBCLabels]
}

// Set provides type-safe dimension setting for JDBC.PoolSize context
func (c JDBCPoolSizeContext) Set(state *framework.CollectorState, labels JDBCLabels, values JDBCPoolSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"size": values.Size,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolSizeContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCPoolUsageValues defines the type-safe values for JDBC.PoolUsage context
type JDBCPoolUsageValues struct {
	Active int64
	Free   int64
}

// JDBCPoolUsageContext provides type-safe operations for JDBC.PoolUsage context
type JDBCPoolUsageContext struct {
	framework.Context[JDBCLabels]
}

// Set provides type-safe dimension setting for JDBC.PoolUsage context
func (c JDBCPoolUsageContext) Set(state *framework.CollectorState, labels JDBCLabels, values JDBCPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
		"free":   values.Free,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCWaitTimeValues defines the type-safe values for JDBC.WaitTime context
type JDBCWaitTimeValues struct {
	Wait int64
}

// JDBCWaitTimeContext provides type-safe operations for JDBC.WaitTime context
type JDBCWaitTimeContext struct {
	framework.Context[JDBCLabels]
}

// Set provides type-safe dimension setting for JDBC.WaitTime context
func (c JDBCWaitTimeContext) Set(state *framework.CollectorState, labels JDBCLabels, values JDBCWaitTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"wait": values.Wait,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCWaitTimeContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCUseTimeValues defines the type-safe values for JDBC.UseTime context
type JDBCUseTimeValues struct {
	Use int64
}

// JDBCUseTimeContext provides type-safe operations for JDBC.UseTime context
type JDBCUseTimeContext struct {
	framework.Context[JDBCLabels]
}

// Set provides type-safe dimension setting for JDBC.UseTime context
func (c JDBCUseTimeContext) Set(state *framework.CollectorState, labels JDBCLabels, values JDBCUseTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"use": values.Use,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCUseTimeContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCConnectionsTotalsValues defines the type-safe values for JDBC.ConnectionsTotals context
type JDBCConnectionsTotalsValues struct {
	Created   int64
	Destroyed int64
}

// JDBCConnectionsTotalsContext provides type-safe operations for JDBC.ConnectionsTotals context
type JDBCConnectionsTotalsContext struct {
	framework.Context[JDBCLabels]
}

// Set provides type-safe dimension setting for JDBC.ConnectionsTotals context
func (c JDBCConnectionsTotalsContext) Set(state *framework.CollectorState, labels JDBCLabels, values JDBCConnectionsTotalsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"created":   values.Created,
		"destroyed": values.Destroyed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCConnectionsTotalsContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCWaitingThreadsValues defines the type-safe values for JDBC.WaitingThreads context
type JDBCWaitingThreadsValues struct {
	Waiting int64
}

// JDBCWaitingThreadsContext provides type-safe operations for JDBC.WaitingThreads context
type JDBCWaitingThreadsContext struct {
	framework.Context[JDBCLabels]
}

// Set provides type-safe dimension setting for JDBC.WaitingThreads context
func (c JDBCWaitingThreadsContext) Set(state *framework.CollectorState, labels JDBCLabels, values JDBCWaitingThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"waiting": values.Waiting,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JDBCWaitingThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels JDBCLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JDBCLabels defines the required labels for JDBC contexts
type JDBCLabels struct {
	Pool string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JDBCLabels) InstanceID(contextName string) string {
	// Label order from YAML: pool
	return contextName + "." + cleanLabelValue(l.Pool)
}

// JDBC contains all metric contexts for JDBC
var JDBC = struct {
	PoolSize          JDBCPoolSizeContext
	PoolUsage         JDBCPoolUsageContext
	WaitTime          JDBCWaitTimeContext
	UseTime           JDBCUseTimeContext
	ConnectionsTotals JDBCConnectionsTotalsContext
	WaitingThreads    JDBCWaitingThreadsContext
}{
	PoolSize: JDBCPoolSizeContext{
		Context: framework.Context[JDBCLabels]{
			Name:        "websphere_jmx.jdbc_pool_size",
			Family:      "workloads/jdbc",
			Title:       "JDBC Pool Size",
			Units:       "connections",
			Type:        module.Line,
			Priority:    601,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	PoolUsage: JDBCPoolUsageContext{
		Context: framework.Context[JDBCLabels]{
			Name:        "websphere_jmx.jdbc_pool_usage",
			Family:      "workloads/jdbc",
			Title:       "JDBC Pool Usage",
			Units:       "connections",
			Type:        module.Stacked,
			Priority:    602,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "free",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	WaitTime: JDBCWaitTimeContext{
		Context: framework.Context[JDBCLabels]{
			Name:        "websphere_jmx.jdbc_pool_wait_time",
			Family:      "workloads/jdbc",
			Title:       "JDBC Average Wait Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    603,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "wait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	UseTime: JDBCUseTimeContext{
		Context: framework.Context[JDBCLabels]{
			Name:        "websphere_jmx.jdbc_pool_use_time",
			Family:      "workloads/jdbc",
			Title:       "JDBC Average Use Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    604,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "use",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	ConnectionsTotals: JDBCConnectionsTotalsContext{
		Context: framework.Context[JDBCLabels]{
			Name:        "websphere_jmx.jdbc_pool_connections",
			Family:      "workloads/jdbc",
			Title:       "JDBC Connections Totals",
			Units:       "connections",
			Type:        module.Line,
			Priority:    605,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "created",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "destroyed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	WaitingThreads: JDBCWaitingThreadsContext{
		Context: framework.Context[JDBCLabels]{
			Name:        "websphere_jmx.jdbc_pool_waiting_threads",
			Family:      "workloads/jdbc",
			Title:       "JDBC Waiting Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    606,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "waiting",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
}

// --- JMS ---

// JMSMessagesCurrentValues defines the type-safe values for JMS.MessagesCurrent context
type JMSMessagesCurrentValues struct {
	Current int64
}

// JMSMessagesCurrentContext provides type-safe operations for JMS.MessagesCurrent context
type JMSMessagesCurrentContext struct {
	framework.Context[JMSLabels]
}

// Set provides type-safe dimension setting for JMS.MessagesCurrent context
func (c JMSMessagesCurrentContext) Set(state *framework.CollectorState, labels JMSLabels, values JMSMessagesCurrentValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSMessagesCurrentContext) SetUpdateEvery(state *framework.CollectorState, labels JMSLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSMessagesPendingValues defines the type-safe values for JMS.MessagesPending context
type JMSMessagesPendingValues struct {
	Pending int64
}

// JMSMessagesPendingContext provides type-safe operations for JMS.MessagesPending context
type JMSMessagesPendingContext struct {
	framework.Context[JMSLabels]
}

// Set provides type-safe dimension setting for JMS.MessagesPending context
func (c JMSMessagesPendingContext) Set(state *framework.CollectorState, labels JMSLabels, values JMSMessagesPendingValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"pending": values.Pending,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSMessagesPendingContext) SetUpdateEvery(state *framework.CollectorState, labels JMSLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSMessagesTotalValues defines the type-safe values for JMS.MessagesTotal context
type JMSMessagesTotalValues struct {
	Total int64
}

// JMSMessagesTotalContext provides type-safe operations for JMS.MessagesTotal context
type JMSMessagesTotalContext struct {
	framework.Context[JMSLabels]
}

// Set provides type-safe dimension setting for JMS.MessagesTotal context
func (c JMSMessagesTotalContext) Set(state *framework.CollectorState, labels JMSLabels, values JMSMessagesTotalValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSMessagesTotalContext) SetUpdateEvery(state *framework.CollectorState, labels JMSLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSConsumersValues defines the type-safe values for JMS.Consumers context
type JMSConsumersValues struct {
	Consumers int64
}

// JMSConsumersContext provides type-safe operations for JMS.Consumers context
type JMSConsumersContext struct {
	framework.Context[JMSLabels]
}

// Set provides type-safe dimension setting for JMS.Consumers context
func (c JMSConsumersContext) Set(state *framework.CollectorState, labels JMSLabels, values JMSConsumersValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"consumers": values.Consumers,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JMSConsumersContext) SetUpdateEvery(state *framework.CollectorState, labels JMSLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JMSLabels defines the required labels for JMS contexts
type JMSLabels struct {
	Destination      string
	Destination_type string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JMSLabels) InstanceID(contextName string) string {
	// Label order from YAML: destination, destination_type
	return contextName + "." + cleanLabelValue(l.Destination) + "_" + cleanLabelValue(l.Destination_type)
}

// JMS contains all metric contexts for JMS
var JMS = struct {
	MessagesCurrent JMSMessagesCurrentContext
	MessagesPending JMSMessagesPendingContext
	MessagesTotal   JMSMessagesTotalContext
	Consumers       JMSConsumersContext
}{
	MessagesCurrent: JMSMessagesCurrentContext{
		Context: framework.Context[JMSLabels]{
			Name:        "websphere_jmx.jms_messages_current",
			Family:      "workloads/jms",
			Title:       "JMS Messages Current Depth",
			Units:       "messages",
			Type:        module.Line,
			Priority:    701,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"destination",
				"destination_type",
			},
		},
	},
	MessagesPending: JMSMessagesPendingContext{
		Context: framework.Context[JMSLabels]{
			Name:        "websphere_jmx.jms_messages_pending",
			Family:      "workloads/jms",
			Title:       "JMS Messages Pending",
			Units:       "messages",
			Type:        module.Line,
			Priority:    702,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "pending",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"destination",
				"destination_type",
			},
		},
	},
	MessagesTotal: JMSMessagesTotalContext{
		Context: framework.Context[JMSLabels]{
			Name:        "websphere_jmx.jms_messages_total",
			Family:      "workloads/jms",
			Title:       "JMS Messages Added Total",
			Units:       "messages",
			Type:        module.Line,
			Priority:    703,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"destination",
				"destination_type",
			},
		},
	},
	Consumers: JMSConsumersContext{
		Context: framework.Context[JMSLabels]{
			Name:        "websphere_jmx.jms_consumers",
			Family:      "workloads/jms",
			Title:       "JMS Consumers",
			Units:       "consumers",
			Type:        module.Line,
			Priority:    704,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "consumers",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"destination",
				"destination_type",
			},
		},
	},
}

// --- JVM ---

// JVMHeapMemoryValues defines the type-safe values for JVM.HeapMemory context
type JVMHeapMemoryValues struct {
	Used      int64
	Committed int64
	Max       int64
}

// JVMHeapMemoryContext provides type-safe operations for JVM.HeapMemory context
type JVMHeapMemoryContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapMemory context
func (c JVMHeapMemoryContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapMemoryValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used":      values.Used,
		"committed": values.Committed,
		"max":       values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapMemoryContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMHeapUsageValues defines the type-safe values for JVM.HeapUsage context
type JVMHeapUsageValues struct {
	Usage int64
}

// JVMHeapUsageContext provides type-safe operations for JVM.HeapUsage context
type JVMHeapUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.HeapUsage context
func (c JVMHeapUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMHeapUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"usage": values.Usage,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMHeapUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMNonHeapMemoryValues defines the type-safe values for JVM.NonHeapMemory context
type JVMNonHeapMemoryValues struct {
	Used      int64
	Committed int64
}

// JVMNonHeapMemoryContext provides type-safe operations for JVM.NonHeapMemory context
type JVMNonHeapMemoryContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.NonHeapMemory context
func (c JVMNonHeapMemoryContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMNonHeapMemoryValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used":      values.Used,
		"committed": values.Committed,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMNonHeapMemoryContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMGCCyclesValues defines the type-safe values for JVM.GCCycles context
type JVMGCCyclesValues struct {
	Collections int64
}

// JVMGCCyclesContext provides type-safe operations for JVM.GCCycles context
type JVMGCCyclesContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.GCCycles context
func (c JVMGCCyclesContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMGCCyclesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"collections": values.Collections,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMGCCyclesContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMGCTimeValues defines the type-safe values for JVM.GCTime context
type JVMGCTimeValues struct {
	Time int64
}

// JVMGCTimeContext provides type-safe operations for JVM.GCTime context
type JVMGCTimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.GCTime context
func (c JVMGCTimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMGCTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"time": values.Time,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMGCTimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMThreadsValues defines the type-safe values for JVM.Threads context
type JVMThreadsValues struct {
	Total  int64
	Daemon int64
}

// JVMThreadsContext provides type-safe operations for JVM.Threads context
type JVMThreadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.Threads context
func (c JVMThreadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total":  values.Total,
		"daemon": values.Daemon,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMThreadStatesValues defines the type-safe values for JVM.ThreadStates context
type JVMThreadStatesValues struct {
	Peak    int64
	Started int64
}

// JVMThreadStatesContext provides type-safe operations for JVM.ThreadStates context
type JVMThreadStatesContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.ThreadStates context
func (c JVMThreadStatesContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMThreadStatesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"peak":    values.Peak,
		"started": values.Started,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMThreadStatesContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMClassesValues defines the type-safe values for JVM.Classes context
type JVMClassesValues struct {
	Loaded   int64
	Unloaded int64
}

// JVMClassesContext provides type-safe operations for JVM.Classes context
type JVMClassesContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.Classes context
func (c JVMClassesContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMClassesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"loaded":   values.Loaded,
		"unloaded": values.Unloaded,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMClassesContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMProcessCPUValues defines the type-safe values for JVM.ProcessCPU context
type JVMProcessCPUValues struct {
	Cpu int64
}

// JVMProcessCPUContext provides type-safe operations for JVM.ProcessCPU context
type JVMProcessCPUContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.ProcessCPU context
func (c JVMProcessCPUContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMProcessCPUValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"cpu": values.Cpu,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMProcessCPUContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVMUptimeValues defines the type-safe values for JVM.Uptime context
type JVMUptimeValues struct {
	Uptime int64
}

// JVMUptimeContext provides type-safe operations for JVM.Uptime context
type JVMUptimeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for JVM.Uptime context
func (c JVMUptimeContext) Set(state *framework.CollectorState, labels EmptyLabels, values JVMUptimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"uptime": values.Uptime,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JVMUptimeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// JVM contains all metric contexts for JVM
var JVM = struct {
	HeapMemory    JVMHeapMemoryContext
	HeapUsage     JVMHeapUsageContext
	NonHeapMemory JVMNonHeapMemoryContext
	GCCycles      JVMGCCyclesContext
	GCTime        JVMGCTimeContext
	Threads       JVMThreadsContext
	ThreadStates  JVMThreadStatesContext
	Classes       JVMClassesContext
	ProcessCPU    JVMProcessCPUContext
	Uptime        JVMUptimeContext
}{
	HeapMemory: JVMHeapMemoryContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_heap_memory",
			Family:      "memory/heap",
			Title:       "JVM Heap Memory",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    201,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "committed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	HeapUsage: JVMHeapUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_heap_usage",
			Family:      "memory/heap",
			Title:       "JVM Heap Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    202,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "usage",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	NonHeapMemory: JVMNonHeapMemoryContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_nonheap_memory",
			Family:      "memory/nonheap",
			Title:       "JVM Non-Heap Memory",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    203,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "committed",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	GCCycles: JVMGCCyclesContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_gc_count",
			Family:      "compute/gc",
			Title:       "JVM Garbage Collection Count",
			Units:       "collections",
			Type:        module.Line,
			Priority:    301,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "collections",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	GCTime: JVMGCTimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_gc_time",
			Family:      "compute/gc",
			Title:       "JVM Garbage Collection Time",
			Units:       "milliseconds",
			Type:        module.Line,
			Priority:    302,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Threads: JVMThreadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_threads",
			Family:      "compute/threads",
			Title:       "JVM Threads",
			Units:       "threads",
			Type:        module.Stacked,
			Priority:    303,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "daemon",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ThreadStates: JVMThreadStatesContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_thread_states",
			Family:      "compute/threads",
			Title:       "JVM Thread States",
			Units:       "threads",
			Type:        module.Line,
			Priority:    304,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "peak",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "started",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Classes: JVMClassesContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_classes",
			Family:      "compute/classes",
			Title:       "JVM Classes",
			Units:       "classes",
			Type:        module.Line,
			Priority:    305,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "loaded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "unloaded",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ProcessCPU: JVMProcessCPUContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_process_cpu_usage",
			Family:      "compute/cpu",
			Title:       "JVM Process CPU Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    103,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "cpu",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	Uptime: JVMUptimeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "websphere_jmx.jvm_uptime",
			Family:      "compute/runtime",
			Title:       "JVM Uptime",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    110,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "uptime",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- ThreadPools ---

// ThreadPoolsSizeValues defines the type-safe values for ThreadPools.Size context
type ThreadPoolsSizeValues struct {
	Size int64
	Max  int64
}

// ThreadPoolsSizeContext provides type-safe operations for ThreadPools.Size context
type ThreadPoolsSizeContext struct {
	framework.Context[ThreadPoolsLabels]
}

// Set provides type-safe dimension setting for ThreadPools.Size context
func (c ThreadPoolsSizeContext) Set(state *framework.CollectorState, labels ThreadPoolsLabels, values ThreadPoolsSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"size": values.Size,
		"max":  values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ThreadPoolsSizeContext) SetUpdateEvery(state *framework.CollectorState, labels ThreadPoolsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ThreadPoolsActiveValues defines the type-safe values for ThreadPools.Active context
type ThreadPoolsActiveValues struct {
	Active int64
}

// ThreadPoolsActiveContext provides type-safe operations for ThreadPools.Active context
type ThreadPoolsActiveContext struct {
	framework.Context[ThreadPoolsLabels]
}

// Set provides type-safe dimension setting for ThreadPools.Active context
func (c ThreadPoolsActiveContext) Set(state *framework.CollectorState, labels ThreadPoolsLabels, values ThreadPoolsActiveValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ThreadPoolsActiveContext) SetUpdateEvery(state *framework.CollectorState, labels ThreadPoolsLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ThreadPoolsLabels defines the required labels for ThreadPools contexts
type ThreadPoolsLabels struct {
	Pool string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ThreadPoolsLabels) InstanceID(contextName string) string {
	// Label order from YAML: pool
	return contextName + "." + cleanLabelValue(l.Pool)
}

// ThreadPools contains all metric contexts for ThreadPools
var ThreadPools = struct {
	Size   ThreadPoolsSizeContext
	Active ThreadPoolsActiveContext
}{
	Size: ThreadPoolsSizeContext{
		Context: framework.Context[ThreadPoolsLabels]{
			Name:        "websphere_jmx.threadpool_size",
			Family:      "workloads/threadpools",
			Title:       "Thread Pool Size",
			Units:       "threads",
			Type:        module.Line,
			Priority:    401,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "size",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
	Active: ThreadPoolsActiveContext{
		Context: framework.Context[ThreadPoolsLabels]{
			Name:        "websphere_jmx.threadpool_active",
			Family:      "workloads/threadpools",
			Title:       "Thread Pool Active Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    402,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"pool",
			},
		},
	},
}

// GetAllContexts returns all contexts for framework registration
func GetAllContexts() []interface{} {
	return []interface{}{
		&Applications.Requests.Context,
		&Applications.ResponseTime.Context,
		&Applications.SessionsActive.Context,
		&Applications.SessionsLive.Context,
		&Applications.SessionEvents.Context,
		&Applications.Transactions.Context,
		&JCA.PoolSize.Context,
		&JCA.PoolUsage.Context,
		&JCA.WaitTime.Context,
		&JCA.UseTime.Context,
		&JCA.ConnectionsTotals.Context,
		&JCA.WaitingThreads.Context,
		&JDBC.PoolSize.Context,
		&JDBC.PoolUsage.Context,
		&JDBC.WaitTime.Context,
		&JDBC.UseTime.Context,
		&JDBC.ConnectionsTotals.Context,
		&JDBC.WaitingThreads.Context,
		&JMS.MessagesCurrent.Context,
		&JMS.MessagesPending.Context,
		&JMS.MessagesTotal.Context,
		&JMS.Consumers.Context,
		&JVM.HeapMemory.Context,
		&JVM.HeapUsage.Context,
		&JVM.NonHeapMemory.Context,
		&JVM.GCCycles.Context,
		&JVM.GCTime.Context,
		&JVM.Threads.Context,
		&JVM.ThreadStates.Context,
		&JVM.Classes.Context,
		&JVM.ProcessCPU.Context,
		&JVM.Uptime.Context,
		&ThreadPools.Size.Context,
		&ThreadPools.Active.Context,
	}
}
