<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/systemdunits/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/systemdunits/metadata.yaml"
sidebar_label: "Systemd Units"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Systemd"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Systemd Units


<img src="https://netdata.cloud/img/systemd.svg" width="150"/>


Plugin: go.d.plugin
Module: systemdunits

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors the state of Systemd units and unit files.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per unit

These metrics refer to the systemd unit.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| unit_name | systemd unit name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| systemd.service_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.socket_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.target_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.path_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.device_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.mount_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.automount_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.swap_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.timer_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.scope_unit_state | active, inactive, activating, deactivating, failed | state |
| systemd.slice_unit_state | active, inactive, activating, deactivating, failed | state |

### Per unit file

These metrics refer to the systemd unit file.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| unit_file_name | systemd unit file name |
| unit_file_type | systemd unit file type |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| systemd.unit_file_state | enabled, enabled-runtime, linked, linked-runtime, alias, masked, masked-runtime, static, disabled, indirect, generated, transient, bad | state |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ systemd_service_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.service_unit_state | systemd service unit in the failed state |
| [ systemd_socket_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.socket_unit_state | systemd socket unit in the failed state |
| [ systemd_target_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.target_unit_state | systemd target unit in the failed state |
| [ systemd_path_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.path_unit_state | systemd path unit in the failed state |
| [ systemd_device_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.device_unit_state | systemd device unit in the failed state |
| [ systemd_mount_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.mount_unit_state | systemd mount unit in the failed state |
| [ systemd_automount_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.automount_unit_state | systemd automount unit in the failed state |
| [ systemd_swap_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.swap_unit_state | systemd swap unit in the failed state |
| [ systemd_scope_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.scope_unit_state | systemd scope unit in the failed state |
| [ systemd_slice_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.slice_unit_state | systemd slice unit in the failed state |
| [ systemd_timer_unit_failed_state ](https://github.com/netdata/netdata/blob/master/src/health/health.d/systemdunits.conf) | systemd.timer_unit_state | systemd timer unit in the failed state |


## Setup


You can configure the **systemdunits** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **systemdunits**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/systemdunits.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection frequency. | 1 | no |
|  | autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
|  | timeout | System bus requests timeout. | 1 | no |
| **Units** | include | Systemd units selector. | *.service | no |
|  | skip_transient | If set, skip data collection for systemd transient units. | false | no |
| **Unit Files** | collect_unit_files | If set to true, collect the state of installed unit files. Enabling this may increase system overhead. | false | no |
|  | collect_unit_files_every | Interval for querying systemd about unit files and their enablement state, measured in seconds. Data is cached for this interval to reduce system overhead. | 300 | no |
|  | include_unit_files | Systemd unit files selector. | *.service | no |

##### include

Systemd units matching the selector will be monitored.

- Logic: (pattern1 OR pattern2)
- Pattern syntax: [shell file name pattern](https://golang.org/pkg/path/filepath/#Match)
- Syntax:

```yaml
includes:
  - pattern1
  - pattern2
```


##### include_unit_files

Systemd unit files matching the selector will be monitored.

- Logic: (pattern1 OR pattern2)
- Pattern syntax: [shell file name pattern](https://golang.org/pkg/path/filepath/#Match)
- Syntax:

```yaml
includes:
  - pattern1
  - pattern2
```



</details>


#### via UI

Configure the **systemdunits** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the systemdunits data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _systemdunits_ (or scroll the list) to locate the **systemdunits** collector.
5. Click the **+** next to the **systemdunits** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/systemdunits.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/systemdunits.conf
```

##### Examples

###### Service units

Collect state of all service type units.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: service
    include:
      - '*.service'

```
</details>

###### One specific unit

Collect state of one specific unit.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my-specific-service
    include:
      - 'my-specific.service'

```
</details>

###### All unit types

Collect state of all units.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: my-specific-service-unit
    include:
      - '*'

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collect state of all service and socket type units.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: service
    include:
      - '*.service'

  - name: socket
    include:
      - '*.socket'

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `systemdunits` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m systemdunits
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m systemdunits -j jobName
  ```

### Getting Logs

If you're encountering problems with the `systemdunits` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep systemdunits
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep systemdunits /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep systemdunits
```


