# Contribute to the documentation

Welcome to our documentation developer guidelines!

This document will guide you to the process of contributing to our docs (**learn.netdata.cloud**)

## Documentation architecture

Our documentation in <https://learn.netdata.cloud> is generated by Markdown documents in the public GitHub repositories of the "netdata" organization.

The structure of the documentation is handled by a [map](https://github.com/netdata/learn/blob/master/map.tsv) file that contains metadata for every Markdown file in the repos we ingest from.

Then the ingest script parses that map and organizes the Markdown files accordingly.

### Improve existing documentation

The easiest way to contribute to Netdata's documentation is to edit a file directly on GitHub. This is perfect for small fixes to a single document, such as fixing a typo or clarifying a confusing sentence.

Each published document on [Netdata Learn](https://learn.netdata.cloud) includes at the bottom a link to **Edit this page**.
Clicking on that link is the recommended way to improve our documentation, as it leads you directly to GitHub's code editor.
Make your suggested changes, and use the ***Preview changes*** button to ensure your Markdown syntax works as expected.

Under the **Commit changes** header, write descriptive title for your requested change. Click the **Commit changes** button to initiate your pull request (PR).

Jump down to our instructions on [PRs](#making-a-pull-request) for your next steps.

### Create a new document

You can create a pull request to add a completely new Markdown document in any of our public repositories.
After the GitHub pull request is merged, our documentation team will decide where in the documentation hierarchy to publish that document.

If you wish to contribute documentation tailored to your specific infrastructure monitoring/troubleshooting experience, please consider submitting a blog post about your experience.

Check out our [blog](https://github.com/netdata/blog#readme) repo! Any blog submissions that have widespread or universal application will be integrated into our permanent documentation.

#### Before you get started

Anyone interested in contributing significantly to documentation should first read the [Netdata style guide](/docs/developer-and-contributor-corner/style-guide.md) and the [Netdata Community Code of Conduct](https://github.com/netdata/.github/blob/main/CODE_OF_CONDUCT.md).

Netdata's documentation uses Markdown syntax. If you're not familiar with Markdown, read the [Mastering Markdown](https://guides.github.com/features/mastering-markdown/) guide from GitHub for the basics on creating paragraphs, styled text, lists, tables, and more.

#### Edit locally

Editing documentation locally is the preferred method for completely new documents, or complex changes that span multiple documents. Clone the repository where you wish to make your changes, work on a new branch, and create a pull request with that branch.

### Links to other documents

Please ensure that any links to a different documentation resource are fully expanded URLs to the relevant Markdown document, not links to "learn.netdata.cloud".

e.g.

```text
[Correct link to this document](/docs/guidelines.md)
vs
[Incorrect link to this document](https://learn.netdata.cloud/XYZ)
```

This permalink ensures that the link will not be broken by any future restructuring in learn.netdata.cloud.

You can see the URL to the source of any published documentation page in the **Edit this page** link at the bottom.
If you just replace `edit` with `blob` in that URL, you have the permalink to the original Markdown document.

### Making a pull request

Pull requests (PRs) should be concise and informative.
See our [PR guidelines](https://github.com/netdata/.github/blob/main/CONTRIBUTING.md#pr-guidelines) for specifics.

The Netdata team will review your PR and assess it for correctness, conciseness, and overall quality.
We may point to specific sections and ask for additional information or other fixes.

After merging your PR, the Netdata team rebuilds the [documentation site](https://learn.netdata.cloud) to publish the changed documentation.
