<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/integrations/ms_exchange.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/windows.plugin/metadata.yaml"
sidebar_label: "MS Exchange"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Windows Systems"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# MS Exchange


<img src="https://netdata.cloud/img/exchange.svg" width="150"/>


Plugin: windows.plugin
Module: PerflibExchange

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Microsoft Exchange.


It queries different Exchange objects from Perflib in order to gather the metrics.


This collector is only supported on the following platforms:

- windows

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

The collector automatically detects all of the metrics, no further configuration is required.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per Windows Exchange

These metrics refer to Windows Exchange.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| exchange.transport_queues_active_mail_box_delivery | active | messages |
| exchange.transport_queues_external_active_remote_delivery | active | messages |
| exchange.transport_queues_internal_active_remote_delivery | active | messages |
| exchange.transport_queues_unreachable | unreachable | messages |
| exchange.transport_queues_poison | unreachable | messages |
| exchange.activesync_ping_cmds_pending | pending | commands |
| exchange.activesync_requests | received | requests/s |
| exchange.activesync_sync_cmds | processed | commands/s |
| exchange.rpc_active_user_count | active | users |
| exchange.rpc_avg_latency | latency | seconds |
| exchange.rpc_connection_count | connections | connections |
| exchange.rpc_requests | processed | requests |
| exchange.rpc_active_user | users | users |
| exchange.rpc_connection | connections | connections |
| exchange.rpc_operations | operations | operations/s |
| exchange.rpc_user_count | users | users |
| exchange.owa_current_unique_users | logged-in | users |
| exchange.owa_requests_total | handled | requests/s |
| exchange.workload_active_tasks | active | tasks |
| exchange.workload_completed_tasks | completed | tasks/s |
| exchange.workload_queued_tasks | queued | tasks/s |
| exchange.workload_yielded_tasks | yielded | tasks/s |
| exchange.workload_activity_status | active, paused | status |
| exchange.http_proxy_avg_auth_latency | latency | seconds |
| exchange.http_proxy_avg_cas_processing_latency_sec | latency | seconds |
| exchange.http_proxy_mailbox_proxy_failure_rate | failures | seconds |
| exchange.http_proxy_mailbox_server_locator_avg_latency_sec | latency | seconds |
| exchange.http_proxy_outstanding_proxy_requests | requests | seconds |
| exchange.http_proxy_requests | requests | seconds |
| exchange.autodiscover_requests | processed | requests/s |
| exchange.avail_service_requests | serviced | requests/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `netdata.conf`.
Configuration for this specific integration is located in the `[plugin:windows:PerflibExchange]` section within that file.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config netdata.conf
```
#### Options



| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update every | Data collection frequency. | 10 | no |

#### Examples
There are no configuration examples.


