<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/apcupsd/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/apcupsd/metadata.yaml"
sidebar_label: "APC UPS"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/UPS"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# APC UPS


<img src="https://netdata.cloud/img/apc.svg" width="150"/>


Plugin: go.d.plugin
Module: apcupsd

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Uninterruptible Power Supplies by polling the Apcupsd daemon.




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects Apcupsd instances running on localhost that are listening on port 3551.
On startup, it tries to collect metrics from:

- 127.0.0.1:3551


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per ups

These metrics refer to the UPS unit.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| apcupsd.ups_status | TRIM, BOOST, CAL, ONLINE, ONBATT, OVERLOAD, LOWBATT, REPLACEBATT, NOBATT, SLAVE, SLAVEDOWN, COMMLOST, SHUTTING_DOWN | status |
| apcupsd.ups_selftest | NO, NG, WN, IP, OK, BT, UNK | status |
| apcupsd.ups_battery_charge | charge | percent |
| apcupsd.ups_battery_time_remaining | timeleft | seconds |
| apcupsd.ups_battery_time_since_replacement | since_replacement | seconds |
| apcupsd.ups_battery_voltage | voltage, nominal_voltage | Volts |
| apcupsd.ups_load_capacity_utilization | load | percent |
| apcupsd.ups_load | load | Watts |
| apcupsd.ups_temperature | temperature | Celsius |
| apcupsd.ups_input_voltage | voltage, min_voltage, max_voltage | Volts |
| apcupsd.ups_input_frequency | frequency | Hz |
| apcupsd.ups_output_voltage | voltage | Volts |



## Alerts


The following alerts are available:

| Alert name  | On metric | Description |
|:------------|:----------|:------------|
| [ apcupsd_ups_load_capacity ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_load_capacity_utilization | APC UPS average load over the last 10 minutes |
| [ apcupsd_ups_battery_charge ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_battery_charge | APC UPS average battery charge over the last minute |
| [ apcupsd_last_collected_secs ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS number of seconds since the last successful data collection |
| [ apcupsd_ups_selftest_warning ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_selftest | APC UPS self-test failed due to insufficient battery capacity or due to overload |
| [ apcupsd_ups_status_onbatt ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS has switched to battery power because the input power has failed |
| [ apcupsd_ups_status_overload ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS is overloaded and cannot supply enough power to the load |
| [ apcupsd_ups_status_lowbatt ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS battery is low and needs to be recharged |
| [ apcupsd_ups_status_replacebatt ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS battery has reached the end of its lifespan and needs to be replaced |
| [ apcupsd_ups_status_nobatt ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS has no battery |
| [ apcupsd_ups_status_commlost ](https://github.com/netdata/netdata/blob/master/src/health/health.d/apcupsd.conf) | apcupsd.ups_status | APC UPS communication link is lost |


## Setup

### Prerequisites

No action required.

### Configuration

#### File

The configuration file name for this integration is `go.d/apcupsd.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/apcupsd.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 1 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| address | Apcupsd daemon address in IP:PORT format. | 127.0.0.1:3551 | yes |
| timeout | Connection/read/write timeout in seconds. The timeout includes name resolution, if required. | 2 | no |

</details>

#### Examples

##### Basic

A basic example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:3551

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    address: 127.0.0.1:3551

  - name: remote
    address: 203.0.113.0:3551

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `apcupsd` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m apcupsd
  ```

### Getting Logs

If you're encountering problems with the `apcupsd` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep apcupsd
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep apcupsd /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep apcupsd
```


