<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/charts.d.plugin/sensors/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/charts.d.plugin/sensors/metadata.yaml"
sidebar_label: "Linux Sensors (sysfs)"
learn_status: "Published"
learn_rel_path: "Data Collection/Hardware Devices and Sensors"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Linux Sensors (sysfs)


<img src="https://netdata.cloud/img/microchip.svg" width="150"/>


Plugin: charts.d.plugin
Module: sensors

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Use this collector when `lm-sensors` doesn't work on your device (e.g. for RPi temperatures).
For all other cases use the [Python collector](https://github.com/netdata/netdata/blob/master/collectors/python.d.plugin/sensors), which supports multiple jobs, is more efficient and performs calculations on top of the kernel provided values."


It will provide charts for all configured system sensors, by reading sensors directly from the kernel.
The values graphed are the raw hardware values of the sensors.


This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, the collector will try to read entries under `/sys/devices`

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per sensor chip

Metrics related to sensor chips. Each chip provides its own set of the following metrics.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| sensors.temp | {filename} | Celsius |
| sensors.volt | {filename} | Volts |
| sensors.curr | {filename} | Ampere |
| sensors.power | {filename} | Watt |
| sensors.fans | {filename} | Rotations / Minute |
| sensors.energy | {filename} | Joule |
| sensors.humidity | {filename} | Percent |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Install charts.d plugin

If [using our official native DEB/RPM packages](https://github.com/netdata/netdata/blob/master/packaging/installer/UPDATE.md#determine-which-installation-method-you-used), make sure `netdata-plugin-chartsd` is installed.


#### Enable the sensors collector

The `sensors` collector is disabled by default. To enable it, use `edit-config` from the Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md), which is typically at `/etc/netdata`, to edit the `charts.d.conf` file.

```bash
cd /etc/netdata   # Replace this path with your Netdata config directory, if different
sudo ./edit-config charts.d.conf
```

Change the value of the `sensors` setting to `force` and uncomment the line. Save the file and restart the Netdata Agent with `sudo systemctl restart netdata`, or the [appropriate method](https://github.com/netdata/netdata/blob/master/docs/configure/start-stop-restart.md) for your system.



### Configuration

#### File

The configuration file name for this integration is `charts.d/sensors.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config charts.d/sensors.conf
```
#### Options

The config file is sourced by the charts.d plugin. It's a standard bash file.

The following collapsed table contains all the options that can be configured for the sensors collector.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| sensors_sys_dir | The directory the kernel exposes sensor data. | /sys/devices | no |
| sensors_sys_depth | How deep in the tree to check for sensor data. | 10 | no |
| sensors_source_update | If set to 1, the script will overwrite internal script functions with code generated ones. | 1 | no |
| sensors_update_every | The data collection frequency. If unset, will inherit the netdata update frequency. | 1 | no |
| sensors_priority | The charts priority on the dashboard. | 90000 | no |
| sensors_retries | The number of retries to do in case of failure before disabling the collector. | 10 | no |

</details>

#### Examples

##### Set sensors path depth

Set a different sensors path depth

```yaml
# the directory the kernel keeps sensor data
#sensors_sys_dir="/sys/devices"

# how deep in the tree to check for sensor data
sensors_sys_depth=5

# if set to 1, the script will overwrite internal
# script functions with code generated ones
# leave to 1, is faster
#sensors_source_update=1

# the data collection frequency
# if unset, will inherit the netdata update frequency
#sensors_update_every=

# the charts priority on the dashboard
#sensors_priority=90000

# the number of retries to do in case of failure
# before disabling the module
#sensors_retries=10

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `sensors` collector, run the `charts.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `charts.d.plugin` to debug the collector:

  ```bash
  ./charts.d.plugin debug 1 sensors
  ```


