/* Copyright 2009, UCAR/Unidata and OPeNDAP, Inc.
   See the COPYRIGHT file for more information. */

#include "config.h"
#include <curl/curl.h>
#include "ocinternal.h"
#include "ocdebug.h"

static int nflags = 0;
static long maxflag = -1;
static struct OCCURLFLAG* nameindices[26]; /* for radix access */
static struct OCCURLFLAG** flagindices = NULL; /* for radix access */

/* Define supported curl flags */

static struct OCCURLFLAG oc_curlflags[] = {
{"CURLOPT_CAINFO",CURLOPT_CAINFO,10065,CF_STRING},
{"CURLOPT_CAPATH",CURLOPT_CAPATH,10097,CF_STRING},
{"CURLOPT_COOKIEFILE",CURLOPT_COOKIEFILE,10031,CF_STRING},
{"CURLOPT_COOKIEJAR",CURLOPT_COOKIEJAR,10082,CF_STRING},
{"CURLOPT_ENCODING",CURLOPT_ENCODING,10102,CF_STRING},
{"CURLOPT_ERRORBUFFER",CURLOPT_ERRORBUFFER,10010,CF_STRING},
{"CURLOPT_FOLLOWLOCATION",CURLOPT_FOLLOWLOCATION,52,CF_LONG},
{"CURLOPT_HTTPAUTH",CURLOPT_HTTPAUTH,1007,CF_LONG},
{"CURLOPT_KEYPASSWD",CURLOPT_KEYPASSWD,10026,CF_STRING},
{"CURLOPT_MAXREDIRS",CURLOPT_MAXREDIRS,68,CF_LONG},
{"CURLOPT_NETRC",CURLOPT_NETRC,51,CF_LONG},
{"CURLOPT_NETRC_FILE",CURLOPT_NETRC_FILE,10118,CF_STRING},
{"CURLOPT_PROXY",CURLOPT_PROXY,10004,CF_STRING},
{"CURLOPT_PROXYAUTH",CURLOPT_PROXYAUTH,111,CF_STRING},
{"CURLOPT_PROXYPORT",CURLOPT_PROXYPORT,59,CF_LONG},
{"CURLOPT_PROXYUSERPWD",CURLOPT_PROXYUSERPWD,10006,CF_STRING},
{"CURLOPT_SSLCERT",CURLOPT_SSLCERT,10025,CF_STRING},
{"CURLOPT_SSLKEY",CURLOPT_SSLKEY,10087,CF_STRING},
{"CURLOPT_SSLKEYPASSWD",CURLOPT_SSLKEYPASSWD,CURLOPT_KEYPASSWD,CF_STRING},
{"CURLOPT_SSL_VERIFYHOST",CURLOPT_SSL_VERIFYHOST,81,CF_LONG},
{"CURLOPT_SSL_VERIFYPEER",CURLOPT_SSL_VERIFYPEER,64,CF_LONG},
{"CURLOPT_TIMEOUT",CURLOPT_TIMEOUT,13,CF_LONG},
{"CURLOPT_USERAGENT",CURLOPT_USERAGENT,10018,CF_STRING},
{"CURLOPT_USERPWD",CURLOPT_USERPWD,10005,CF_STRING},
{"CURLOPT_VERBOSE",CURLOPT_VERBOSE,41,CF_LONG},
{"CURLOPT_USE_SSL",CURLOPT_USE_SSL,119,CF_LONG},
{NULL,0}
};

#if 0
static struct OCCURLFLAG oc_allcurlflags[] = {
{"CURLOPT_ADDRESS_SCOPE",CURLOPT_ADDRESS_SCOPE,171,CF_UNKNOWN},
{"CURLOPT_APPEND",CURLOPT_APPEND,50,CF_UNKNOWN},
{"CURLOPT_AUTOREFERER",CURLOPT_AUTOREFERER,58,CF_UNKNOWN},
{"CURLOPT_BUFFERSIZE",CURLOPT_BUFFERSIZE,98,CF_UNKNOWN},
{"CURLOPT_CAINFO",CURLOPT_CAINFO,10065,CF_UNKNOWN},
{"CURLOPT_CAPATH",CURLOPT_CAPATH,10097,CF_UNKNOWN},
{"CURLOPT_CERTINFO",CURLOPT_CERTINFO,172,CF_UNKNOWN},
{"CURLOPT_CHUNK_BGN_FUNCTION",CURLOPT_CHUNK_BGN_FUNCTION,20198,CF_UNKNOWN},
{"CURLOPT_CHUNK_DATA",CURLOPT_CHUNK_DATA,10201,CF_UNKNOWN},
{"CURLOPT_CHUNK_END_FUNCTION",CURLOPT_CHUNK_END_FUNCTION,20199,CF_UNKNOWN},
{"CURLOPT_CLOSEPOLICY",CURLOPT_CLOSEPOLICY,72,CF_UNKNOWN},
{"CURLOPT_CONNECT_ONLY",CURLOPT_CONNECT_ONLY,141,CF_UNKNOWN},
{"CURLOPT_CONNECTTIMEOUT",CURLOPT_CONNECTTIMEOUT,78,CF_UNKNOWN},
{"CURLOPT_CONNECTTIMEOUT_MS",CURLOPT_CONNECTTIMEOUT_MS,156,CF_UNKNOWN},
{"CURLOPT_CONV_FROM_NETWORK_FUNCTION",CURLOPT_CONV_FROM_NETWORK_FUNCTION,20142,CF_UNKNOWN},
{"CURLOPT_CONV_FROM_UTF8_FUNCTION",CURLOPT_CONV_FROM_UTF8_FUNCTION,20144,CF_UNKNOWN},
{"CURLOPT_CONV_TO_NETWORK_FUNCTION",CURLOPT_CONV_TO_NETWORK_FUNCTION,20143,CF_UNKNOWN},
{"CURLOPT_COOKIE",CURLOPT_COOKIE,10022,CF_UNKNOWN},
{"CURLOPT_COOKIEFILE",CURLOPT_COOKIEFILE,10031,CF_UNKNOWN},
{"CURLOPT_COOKIEJAR",CURLOPT_COOKIEJAR,10082,CF_UNKNOWN},
{"CURLOPT_COOKIELIST",CURLOPT_COOKIELIST,10135,CF_UNKNOWN},
{"CURLOPT_COOKIESESSION",CURLOPT_COOKIESESSION,96,CF_UNKNOWN},
{"CURLOPT_COPYPOSTFIELDS",CURLOPT_COPYPOSTFIELDS,10165,CF_UNKNOWN},
{"CURLOPT_CRLF",CURLOPT_CRLF,27,CF_UNKNOWN},
{"CURLOPT_CRLFILE",CURLOPT_CRLFILE,10169,CF_UNKNOWN},
{"CURLOPT_CUSTOMREQUEST",CURLOPT_CUSTOMREQUEST,10036,CF_UNKNOWN},
{"CURLOPT_DEBUGDATA",CURLOPT_DEBUGDATA,10095,CF_UNKNOWN},
{"CURLOPT_DEBUGFUNCTION",CURLOPT_DEBUGFUNCTION,20094,CF_UNKNOWN},
{"CURLOPT_DIRLISTONLY",CURLOPT_DIRLISTONLY,48,CF_UNKNOWN},
{"CURLOPT_DNS_CACHE_TIMEOUT",CURLOPT_DNS_CACHE_TIMEOUT,92,CF_UNKNOWN},
{"CURLOPT_DNS_USE_GLOBAL_CACHE",CURLOPT_DNS_USE_GLOBAL_CACHE,91,CF_UNKNOWN},
{"CURLOPT_EGDSOCKET",CURLOPT_EGDSOCKET,10077,CF_UNKNOWN},
{"CURLOPT_ENCODING",CURLOPT_ENCODING,10102,CF_UNKNOWN},
{"CURLOPT_ERRORBUFFER",CURLOPT_ERRORBUFFER,10010,CF_UNKNOWN},
{"CURLOPT_FAILONERROR",CURLOPT_FAILONERROR,45,CF_UNKNOWN},
{"CURLOPT_FILE",CURLOPT_FILE,10001,CF_UNKNOWN},
{"CURLOPT_FILETIME",CURLOPT_FILETIME,69,CF_UNKNOWN},
{"CURLOPT_FNMATCH_DATA",CURLOPT_FNMATCH_DATA,10202,CF_UNKNOWN},
{"CURLOPT_FNMATCH_FUNCTION",CURLOPT_FNMATCH_FUNCTION,20200,CF_UNKNOWN},
{"CURLOPT_FOLLOWLOCATION",CURLOPT_FOLLOWLOCATION,52,CF_UNKNOWN},
{"CURLOPT_FORBID_REUSE",CURLOPT_FORBID_REUSE,75,CF_UNKNOWN},
{"CURLOPT_FRESH_CONNECT",CURLOPT_FRESH_CONNECT,74,CF_UNKNOWN},
{"CURLOPT_FTP_ACCOUNT",CURLOPT_FTP_ACCOUNT,10134,CF_UNKNOWN},
{"CURLOPT_FTP_ALTERNATIVE_TO_USER",CURLOPT_FTP_ALTERNATIVE_TO_USER,10147,CF_UNKNOWN},
{"CURLOPT_FTP_CREATE_MISSING_DIRS",CURLOPT_FTP_CREATE_MISSING_DIRS,110,CF_UNKNOWN},
{"CURLOPT_FTP_FILEMETHOD",CURLOPT_FTP_FILEMETHOD,138,CF_UNKNOWN},
{"CURLOPT_FTPPORT",CURLOPT_FTPPORT,10017,CF_UNKNOWN},
{"CURLOPT_FTP_RESPONSE_TIMEOUT",CURLOPT_FTP_RESPONSE_TIMEOUT,112,CF_UNKNOWN},
{"CURLOPT_FTP_SKIP_PASV_IP",CURLOPT_FTP_SKIP_PASV_IP,137,CF_UNKNOWN},
{"CURLOPT_FTPSSLAUTH",CURLOPT_FTPSSLAUTH,129,CF_UNKNOWN},
{"CURLOPT_FTP_SSL_CCC",CURLOPT_FTP_SSL_CCC,154,CF_UNKNOWN},
{"CURLOPT_FTP_USE_EPRT",CURLOPT_FTP_USE_EPRT,106,CF_UNKNOWN},
{"CURLOPT_FTP_USE_EPSV",CURLOPT_FTP_USE_EPSV,85,CF_UNKNOWN},
{"CURLOPT_FTP_USE_PRET",CURLOPT_FTP_USE_PRET,188,CF_UNKNOWN},
{"CURLOPT_GSSAPI_DELEGATION",CURLOPT_GSSAPI_DELEGATION,210,CF_UNKNOWN},
{"CURLOPT_HEADER",CURLOPT_HEADER,42,CF_UNKNOWN},
{"CURLOPT_HEADERFUNCTION",CURLOPT_HEADERFUNCTION,20079,CF_UNKNOWN},
{"CURLOPT_HTTP200ALIASES",CURLOPT_HTTP200ALIASES,10104,CF_UNKNOWN},
{"CURLOPT_HTTPAUTH",CURLOPT_HTTPAUTH,107,CF_UNKNOWN},
{"CURLOPT_HTTP_CONTENT_DECODING",CURLOPT_HTTP_CONTENT_DECODING,158,CF_UNKNOWN},
{"CURLOPT_HTTPGET",CURLOPT_HTTPGET,80,CF_UNKNOWN},
{"CURLOPT_HTTPHEADER",CURLOPT_HTTPHEADER,10023,CF_UNKNOWN},
{"CURLOPT_HTTPPOST",CURLOPT_HTTPPOST,10024,CF_UNKNOWN},
{"CURLOPT_HTTPPROXYTUNNEL",CURLOPT_HTTPPROXYTUNNEL,61,CF_UNKNOWN},
{"CURLOPT_HTTP_TRANSFER_DECODING",CURLOPT_HTTP_TRANSFER_DECODING,157,CF_UNKNOWN},
{"CURLOPT_HTTP_VERSION",CURLOPT_HTTP_VERSION,84,CF_UNKNOWN},
{"CURLOPT_IGNORE_CONTENT_LENGTH",CURLOPT_IGNORE_CONTENT_LENGTH,136,CF_UNKNOWN},
{"CURLOPT_INFILE",CURLOPT_INFILE,10009,CF_UNKNOWN},
{"CURLOPT_INFILESIZE",CURLOPT_INFILESIZE,14,CF_UNKNOWN},
{"CURLOPT_INFILESIZE_LARGE",CURLOPT_INFILESIZE_LARGE,30115,CF_UNKNOWN},
{"CURLOPT_INTERFACE",CURLOPT_INTERFACE,10062,CF_UNKNOWN},
{"CURLOPT_INTERLEAVEDATA",CURLOPT_INTERLEAVEDATA,10195,CF_UNKNOWN},
{"CURLOPT_INTERLEAVEFUNCTION",CURLOPT_INTERLEAVEFUNCTION,20196,CF_UNKNOWN},
{"CURLOPT_IOCTLDATA",CURLOPT_IOCTLDATA,10131,CF_UNKNOWN},
{"CURLOPT_IOCTLFUNCTION",CURLOPT_IOCTLFUNCTION,20130,CF_UNKNOWN},
{"CURLOPT_IPRESOLVE",CURLOPT_IPRESOLVE,113,CF_UNKNOWN},
{"CURLOPT_ISSUERCERT",CURLOPT_ISSUERCERT,10170,CF_UNKNOWN},
{"CURLOPT_KEYPASSWD",CURLOPT_KEYPASSWD,10026,CF_UNKNOWN},
{"CURLOPT_KRBLEVEL",CURLOPT_KRBLEVEL,10063,CF_UNKNOWN},
{"CURLOPT_LOCALPORT",CURLOPT_LOCALPORT,139,CF_UNKNOWN},
{"CURLOPT_LOCALPORTRANGE",CURLOPT_LOCALPORTRANGE,140,CF_UNKNOWN},
{"CURLOPT_LOW_SPEED_LIMIT",CURLOPT_LOW_SPEED_LIMIT,19,CF_UNKNOWN},
{"CURLOPT_LOW_SPEED_TIME",CURLOPT_LOW_SPEED_TIME,20,CF_UNKNOWN},
{"CURLOPT_MAIL_FROM",CURLOPT_MAIL_FROM,10186,CF_UNKNOWN},
{"CURLOPT_MAIL_RCPT",CURLOPT_MAIL_RCPT,10187,CF_UNKNOWN},
{"CURLOPT_MAXCONNECTS",CURLOPT_MAXCONNECTS,71,CF_UNKNOWN},
{"CURLOPT_MAXFILESIZE",CURLOPT_MAXFILESIZE,114,CF_UNKNOWN},
{"CURLOPT_MAXFILESIZE_LARGE",CURLOPT_MAXFILESIZE_LARGE,30117,CF_UNKNOWN},
{"CURLOPT_MAX_RECV_SPEED_LARGE",CURLOPT_MAX_RECV_SPEED_LARGE,30146,CF_UNKNOWN},
{"CURLOPT_MAXREDIRS",CURLOPT_MAXREDIRS,68,CF_UNKNOWN},
{"CURLOPT_MAX_SEND_SPEED_LARGE",CURLOPT_MAX_SEND_SPEED_LARGE,30145,CF_UNKNOWN},
{"CURLOPT_NETRC",CURLOPT_NETRC,51,CF_UNKNOWN},
{"CURLOPT_NETRC_FILE",CURLOPT_NETRC_FILE,10118,CF_UNKNOWN},
{"CURLOPT_NEW_DIRECTORY_PERMS",CURLOPT_NEW_DIRECTORY_PERMS,160,CF_UNKNOWN},
{"CURLOPT_NEW_FILE_PERMS",CURLOPT_NEW_FILE_PERMS,159,CF_UNKNOWN},
{"CURLOPT_NOBODY",CURLOPT_NOBODY,44,CF_UNKNOWN},
{"CURLOPT_NOPROGRESS",CURLOPT_NOPROGRESS,43,CF_UNKNOWN},
{"CURLOPT_NOPROXY",CURLOPT_NOPROXY,10177,CF_UNKNOWN},
{"CURLOPT_NOSIGNAL",CURLOPT_NOSIGNAL,99,CF_UNKNOWN},
{"CURLOPT_OPENSOCKETDATA",CURLOPT_OPENSOCKETDATA,10164,CF_UNKNOWN},
{"CURLOPT_OPENSOCKETFUNCTION",CURLOPT_OPENSOCKETFUNCTION,20163,CF_UNKNOWN},
{"CURLOPT_PASSWORD",CURLOPT_PASSWORD,10174,CF_UNKNOWN},
{"CURLOPT_PORT",CURLOPT_PORT,3,CF_UNKNOWN},
{"CURLOPT_POST",CURLOPT_POST,47,CF_UNKNOWN},
{"CURLOPT_POSTFIELDS",CURLOPT_POSTFIELDS,10015,CF_UNKNOWN},
{"CURLOPT_POSTFIELDSIZE",CURLOPT_POSTFIELDSIZE,60,CF_UNKNOWN},
{"CURLOPT_POSTFIELDSIZE_LARGE",CURLOPT_POSTFIELDSIZE_LARGE,30120,CF_UNKNOWN},
{"CURLOPT_POSTQUOTE",CURLOPT_POSTQUOTE,10039,CF_UNKNOWN},
{"CURLOPT_POSTREDIR",CURLOPT_POSTREDIR,161,CF_UNKNOWN},
{"CURLOPT_PREQUOTE",CURLOPT_PREQUOTE,10093,CF_UNKNOWN},
{"CURLOPT_PRIVATE",CURLOPT_PRIVATE,10103,CF_UNKNOWN},
{"CURLOPT_PROGRESSDATA",CURLOPT_PROGRESSDATA,10057,CF_UNKNOWN},
{"CURLOPT_PROGRESSFUNCTION",CURLOPT_PROGRESSFUNCTION,20056,CF_UNKNOWN},
{"CURLOPT_PROTOCOLS",CURLOPT_PROTOCOLS,181,CF_UNKNOWN},
{"CURLOPT_PROXY",CURLOPT_PROXY,10004,CF_UNKNOWN},
{"CURLOPT_PROXYAUTH",CURLOPT_PROXYAUTH,111,CF_UNKNOWN},
{"CURLOPT_PROXYPASSWORD",CURLOPT_PROXYPASSWORD,10176,CF_UNKNOWN},
{"CURLOPT_PROXYPORT",CURLOPT_PROXYPORT,59,CF_UNKNOWN},
{"CURLOPT_PROXY_TRANSFER_MODE",CURLOPT_PROXY_TRANSFER_MODE,166,CF_UNKNOWN},
{"CURLOPT_PROXYTYPE",CURLOPT_PROXYTYPE,101,CF_UNKNOWN},
{"CURLOPT_PROXYUSERNAME",CURLOPT_PROXYUSERNAME,10175,CF_UNKNOWN},
{"CURLOPT_PROXYUSERPWD",CURLOPT_PROXYUSERPWD,10006,CF_UNKNOWN},
{"CURLOPT_PUT",CURLOPT_PUT,54,CF_UNKNOWN},
{"CURLOPT_QUOTE",CURLOPT_QUOTE,10028,CF_UNKNOWN},
{"CURLOPT_RANDOM_FILE",CURLOPT_RANDOM_FILE,10076,CF_UNKNOWN},
{"CURLOPT_RANGE",CURLOPT_RANGE,10007,CF_UNKNOWN},
{"CURLOPT_READFUNCTION",CURLOPT_READFUNCTION,20012,CF_UNKNOWN},
{"CURLOPT_REDIR_PROTOCOLS",CURLOPT_REDIR_PROTOCOLS,182,CF_UNKNOWN},
{"CURLOPT_REFERER",CURLOPT_REFERER,10016,CF_UNKNOWN},
{"CURLOPT_RESUME_FROM",CURLOPT_RESUME_FROM,21,CF_UNKNOWN},
{"CURLOPT_RESUME_FROM_LARGE",CURLOPT_RESUME_FROM_LARGE,30116,CF_UNKNOWN},
{"CURLOPT_RTSP_CLIENT_CSEQ",CURLOPT_RTSP_CLIENT_CSEQ,193,CF_UNKNOWN},
{"CURLOPT_RTSP_REQUEST",CURLOPT_RTSP_REQUEST,189,CF_UNKNOWN},
{"CURLOPT_RTSP_SERVER_CSEQ",CURLOPT_RTSP_SERVER_CSEQ,194,CF_UNKNOWN},
{"CURLOPT_RTSP_SESSION_ID",CURLOPT_RTSP_SESSION_ID,10190,CF_UNKNOWN},
{"CURLOPT_RTSP_STREAM_URI",CURLOPT_RTSP_STREAM_URI,10191,CF_UNKNOWN},
{"CURLOPT_RTSP_TRANSPORT",CURLOPT_RTSP_TRANSPORT,10192,CF_UNKNOWN},
{"CURLOPT_SEEKDATA",CURLOPT_SEEKDATA,10168,CF_UNKNOWN},
{"CURLOPT_SEEKFUNCTION",CURLOPT_SEEKFUNCTION,20167,CF_UNKNOWN},
{"CURLOPT_SHARE",CURLOPT_SHARE,10100,CF_UNKNOWN},
{"CURLOPT_SOCKOPTDATA",CURLOPT_SOCKOPTDATA,10149,CF_UNKNOWN},
{"CURLOPT_SOCKOPTFUNCTION",CURLOPT_SOCKOPTFUNCTION,20148,CF_UNKNOWN},
{"CURLOPT_SOCKS5_GSSAPI_NEC",CURLOPT_SOCKS5_GSSAPI_NEC,180,CF_UNKNOWN},
{"CURLOPT_SOCKS5_GSSAPI_SERVICE",CURLOPT_SOCKS5_GSSAPI_SERVICE,10179,CF_UNKNOWN},
{"CURLOPT_SSH_AUTH_TYPES",CURLOPT_SSH_AUTH_TYPES,151,CF_UNKNOWN},
{"CURLOPT_SSH_HOST_PUBLIC_KEY_MD5",CURLOPT_SSH_HOST_PUBLIC_KEY_MD5,10162,CF_UNKNOWN},
{"CURLOPT_SSH_KEYDATA",CURLOPT_SSH_KEYDATA,10185,CF_UNKNOWN},
{"CURLOPT_SSH_KEYFUNCTION",CURLOPT_SSH_KEYFUNCTION,20184,CF_UNKNOWN},
{"CURLOPT_SSH_KNOWNHOSTS",CURLOPT_SSH_KNOWNHOSTS,10183,CF_UNKNOWN},
{"CURLOPT_SSH_PRIVATE_KEYFILE",CURLOPT_SSH_PRIVATE_KEYFILE,10153,CF_UNKNOWN},
{"CURLOPT_SSH_PUBLIC_KEYFILE",CURLOPT_SSH_PUBLIC_KEYFILE,10152,CF_UNKNOWN},
{"CURLOPT_SSLCERT",CURLOPT_SSLCERT,10025,CF_UNKNOWN},
{"CURLOPT_SSLCERTTYPE",CURLOPT_SSLCERTTYPE,10086,CF_UNKNOWN},
{"CURLOPT_SSL_CIPHER_LIST",CURLOPT_SSL_CIPHER_LIST,10083,CF_UNKNOWN},
{"CURLOPT_SSL_CTX_DATA",CURLOPT_SSL_CTX_DATA,10109,CF_UNKNOWN},
{"CURLOPT_SSL_CTX_FUNCTION",CURLOPT_SSL_CTX_FUNCTION,20108,CF_UNKNOWN},
{"CURLOPT_SSLENGINE",CURLOPT_SSLENGINE,10089,CF_UNKNOWN},
{"CURLOPT_SSLENGINE_DEFAULT",CURLOPT_SSLENGINE_DEFAULT,90,CF_UNKNOWN},
{"CURLOPT_SSLKEY",CURLOPT_SSLKEY,10087,CF_UNKNOWN},
{"CURLOPT_SSLKEYTYPE",CURLOPT_SSLKEYTYPE,10088,CF_UNKNOWN},
{"CURLOPT_SSL_SESSIONID_CACHE",CURLOPT_SSL_SESSIONID_CACHE,150,CF_UNKNOWN},
{"CURLOPT_SSL_VERIFYHOST",CURLOPT_SSL_VERIFYHOST,81,CF_UNKNOWN},
{"CURLOPT_SSL_VERIFYPEER",CURLOPT_SSL_VERIFYPEER,64,CF_UNKNOWN},
{"CURLOPT_SSLVERSION",CURLOPT_SSLVERSION,32,CF_UNKNOWN},
{"CURLOPT_STDERR",CURLOPT_STDERR,10037,CF_UNKNOWN},
{"CURLOPT_TCP_NODELAY",CURLOPT_TCP_NODELAY,121,CF_UNKNOWN},
{"CURLOPT_TELNETOPTIONS",CURLOPT_TELNETOPTIONS,10070,CF_UNKNOWN},
{"CURLOPT_TFTP_BLKSIZE",CURLOPT_TFTP_BLKSIZE,178,CF_UNKNOWN},
{"CURLOPT_TIMECONDITION",CURLOPT_TIMECONDITION,33,CF_UNKNOWN},
{"CURLOPT_TIMEOUT",CURLOPT_TIMEOUT,13,CF_UNKNOWN},
{"CURLOPT_TIMEOUT_MS",CURLOPT_TIMEOUT_MS,155,CF_UNKNOWN},
{"CURLOPT_TIMEVALUE",CURLOPT_TIMEVALUE,34,CF_UNKNOWN},
{"CURLOPT_TRANSFERTEXT",CURLOPT_TRANSFERTEXT,53,CF_UNKNOWN},
{"CURLOPT_UNRESTRICTED_AUTH",CURLOPT_UNRESTRICTED_AUTH,105,CF_UNKNOWN},
{"CURLOPT_UPLOAD",CURLOPT_UPLOAD,46,CF_UNKNOWN},
{"CURLOPT_URL",CURLOPT_URL,10002,CF_UNKNOWN},
{"CURLOPT_USERAGENT",CURLOPT_USERAGENT,10018,CF_UNKNOWN},
{"CURLOPT_USERNAME",CURLOPT_USERNAME,10173,CF_UNKNOWN},
{"CURLOPT_USERPWD",CURLOPT_USERPWD,10005,CF_UNKNOWN},
{"CURLOPT_USE_SSL",CURLOPT_USE_SSL,119,CF_UNKNOWN},
{"CURLOPT_VERBOSE",CURLOPT_VERBOSE,41,CF_UNKNOWN},
{"CURLOPT_WILDCARDMATCH",CURLOPT_WILDCARDMATCH,197,CF_UNKNOWN},
{"CURLOPT_WRITEFUNCTION",CURLOPT_WRITEFUNCTION,20011,CF_UNKNOWN},
{"CURLOPT_WRITEHEADER",CURLOPT_WRITEHEADER,10029,CF_UNKNOWN},
{"CURLOPT_WRITEINFO",CURLOPT_WRITEINFO,10040,CF_UNKNOWN},
{NULL,0}
};

struct OCCURLFLAG*
occurlflagsall(void)
{
    if(nflags == 0) initialize();
    return oc_allcurlflags;
}

#endif

static int touppercase(int c)
{
    if(c >= 'a' && c <= 'z')
	c = ((c-'a') + 'A');
    return c;
}

static void
initialize(void)
{
  struct OCCURLFLAG* p;
  size_t len = 0;

  if(nflags == 0) {  /* initialize */
	maxflag = -1;
    for(p=oc_curlflags;p->name;p++) {
      int c;
      nflags++; /* count number of flags */
      if(p->flag > maxflag) maxflag = p->flag;
      /* construct alphabetic radix nameindices */
      c = p->name[0];
      OCASSERT(c >= 'A' && c <= 'Z');
      if(nameindices[c] == NULL)
		nameindices[c] = p;
	}


    len = maxflag;
    if(maxflag == -1) len += 2; else len += 1;
    flagindices = (struct OCCURLFLAG**)calloc(1,len*sizeof(struct OCCURLFLAG*));
    for(p=oc_curlflags;p->name;p++)
      flagindices[p->flag] = p;
  }
}

struct OCCURLFLAG*
occurlflags(void)
{
    if(nflags == 0) initialize();
    return oc_curlflags;
}

struct OCCURLFLAG*
occurlflagbyname(const char* name)
{
    struct OCCURLFLAG* f;
    int c = name[0];
    char flagname[4096];
    const char* p;
    char* q;

    if(nflags == 0) initialize();
    /* Force upper case */
    for(p=name,q=flagname;*p;p++) {
        int cc = touppercase(*p);
        if(cc < 'A' || cc > 'Z') return NULL;
        *q++ = cc;
    }
    *q = '\0';

    if(nameindices[c] == NULL)
	return NULL; /* no possible match */
    for(f=nameindices[c];f->name;f++) {
	int cmp = strcmp(name,f->name);
	if(cmp > 0) break; /* We assume sorted */
	if(cmp == 0) return f;
    }
    return NULL;
}

struct OCCURLFLAG*
occurlflagbyflag(int flag)
{
    if(nflags == 0) initialize();
    if(flag >= 0 || flag <= maxflag)
	return flagindices[flag];
    return NULL;
}
