if(WIN32)
  set(UNIBILIUM_CONFIGURE_COMMAND ${CMAKE_COMMAND} -E copy
      ${CMAKE_CURRENT_SOURCE_DIR}/cmake/UnibiliumCMakeLists.txt
      ${DEPS_BUILD_DIR}/src/unibilium/CMakeLists.txt
    COMMAND ${CMAKE_COMMAND} ${DEPS_BUILD_DIR}/src/unibilium
      -DCMAKE_INSTALL_PREFIX=${DEPS_INSTALL_DIR}
      -DCMAKE_GENERATOR_PLATFORM=${CMAKE_GENERATOR_PLATFORM}
      ${BUILD_TYPE_STRING}
      -DCMAKE_GENERATOR=${CMAKE_GENERATOR})
  set(UNIBILIUM_BUILD_COMMAND ${CMAKE_COMMAND} --build . --config $<CONFIG>)
  set(UNIBILIUM_INSTALL_COMMAND ${CMAKE_COMMAND} --build . --target install --config $<CONFIG>)
else()
  set(UNIBILIUM_BUILD_COMMAND ${MAKE_PRG} CC=${DEPS_C_COMPILER}
      PREFIX=${DEPS_INSTALL_DIR} CFLAGS=-fPIC LDFLAGS+=-static
    BUILD_IN_SOURCE 1)
  set(UNIBILIUM_INSTALL_COMMAND ${MAKE_PRG} PREFIX=${DEPS_INSTALL_DIR} install)
endif()

if(USE_EXISTING_SRC_DIR)
  unset(UNIBILIUM_URL)
endif()
ExternalProject_Add(unibilium
  URL ${UNIBILIUM_URL}
  URL_HASH SHA256=${UNIBILIUM_SHA256}
  DOWNLOAD_NO_PROGRESS TRUE
  DOWNLOAD_DIR ${DEPS_DOWNLOAD_DIR}/unibilium
  CONFIGURE_COMMAND "${UNIBILIUM_CONFIGURE_COMMAND}"
  BUILD_COMMAND "${UNIBILIUM_BUILD_COMMAND}"
  INSTALL_COMMAND "${UNIBILIUM_INSTALL_COMMAND}")

list(APPEND THIRD_PARTY_DEPS unibilium)
