set(LPEG_INCLUDE_FLAGS ${DEPS_INCLUDE_FLAGS})

if(NOT USE_BUNDLED_LUAJIT AND NOT USE_BUNDLED_LUA)
  find_package(Luajit)
  if(LUAJIT_FOUND)
    string(CONCAT LPEG_INCLUDE_FLAGS ${DEPS_INCLUDE_FLAGS} " -I${LUAJIT_INCLUDE_DIR}")
  else()
    find_package(Lua 5.1 EXACT)
    if(LUA_FOUND)
      string(CONCAT LPEG_INCLUDE_FLAGS ${DEPS_INCLUDE_FLAGS} " -I${LUA_INCLUDE_DIR}")
    endif()
  endif()
endif()

list(APPEND LPEG_CMAKE_ARGS -DCMAKE_C_FLAGS=${LPEG_INCLUDE_FLAGS})

ExternalProject_Add(lpeg
  URL ${LPEG_URL}
  URL_HASH SHA256=${LPEG_SHA256}
  DOWNLOAD_NO_PROGRESS TRUE
  DOWNLOAD_DIR ${DEPS_DOWNLOAD_DIR}/lpeg
  PATCH_COMMAND ${CMAKE_COMMAND} -E copy
    ${CMAKE_CURRENT_SOURCE_DIR}/cmake/LpegCMakeLists.txt
    ${DEPS_BUILD_DIR}/src/lpeg/CMakeLists.txt
  CMAKE_ARGS ${DEPS_CMAKE_ARGS} ${LPEG_CMAKE_ARGS}
  CMAKE_CACHE_ARGS ${DEPS_CMAKE_CACHE_ARGS})

if(USE_BUNDLED_LUAJIT)
  add_dependencies(lpeg luajit)
elseif(USE_BUNDLED_LUA)
  add_dependencies(lpeg lua)
endif()
