function(BuildTSParser LANG TS_URL TS_SHA256 TS_CMAKE_FILE)
  set(NAME treesitter-${LANG})
  ExternalProject_Add(${NAME}
  PREFIX ${DEPS_BUILD_DIR}
  URL ${TREESITTER_C_URL}
  DOWNLOAD_DIR ${DEPS_DOWNLOAD_DIR}/${NAME}
  DOWNLOAD_COMMAND ${CMAKE_COMMAND}
    -DPREFIX=${DEPS_BUILD_DIR}
    -DDOWNLOAD_DIR=${DEPS_DOWNLOAD_DIR}/${NAME}
    -DURL=${TS_URL}
    -DEXPECTED_SHA256=${TS_SHA256}
    -DTARGET=${NAME}
    -DUSE_EXISTING_SRC_DIR=${USE_EXISTING_SRC_DIR}
    -P ${CMAKE_CURRENT_SOURCE_DIR}/cmake/DownloadAndExtractFile.cmake
  PATCH_COMMAND ${CMAKE_COMMAND} -E copy
      ${CMAKE_CURRENT_SOURCE_DIR}/cmake/${TS_CMAKE_FILE}
      ${DEPS_BUILD_DIR}/src/${NAME}/CMakeLists.txt
  CMAKE_ARGS
    -DCMAKE_INSTALL_PREFIX=${DEPS_INSTALL_DIR}
    -DPARSERLANG=${LANG})
endfunction()

BuildTSParser(c ${TREESITTER_C_URL} ${TREESITTER_C_SHA256} TreesitterParserCMakeLists.txt)
BuildTSParser(lua ${TREESITTER_LUA_URL} ${TREESITTER_LUA_SHA256} TreesitterParserCMakeLists.txt)
BuildTSParser(vim ${TREESITTER_VIM_URL} ${TREESITTER_VIM_SHA256} TreesitterParserCMakeLists.txt)
