///////////////////////////////////////////////////////////////////////////////
//
// File: NodalTriElecData.h
//
// For more information, please see: http://www.nektar.info
//
// The MIT License
//
// Copyright (c) 2006 Division of Applied Mathematics, Brown University (USA),
// Department of Aeronautics, Imperial College London (UK), and Scientific
// Computing and Imaging Institute, University of Utah (USA).
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included
// in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//
// Description:
//
///////////////////////////////////////////////////////////////////////////////

namespace Nektar
{
namespace LibUtilities
{
static const size_t perm3A_2d[3][3] = {
    {0, 1, 2}, {2, 0, 1}, {0, 2, 1}}; // Works for aab
static const size_t perm3B_2d[3][3] = {
    {0, 1, 2}, {1, 0, 2}, {1, 2, 0}}; // Works for abb
static const size_t perm6_2d[6][3] = {
    {0, 1, 2}, {1, 0, 2}, {2, 0, 1}, // Works for abc
    {2, 1, 0}, {0, 2, 1}, {1, 2, 0}};
const size_t NodalTriElecAvailable                          = 16;
static const size_t NodalTriElecNPTS[NodalTriElecAvailable] = {
    1, 2, 3, 4, 5, 7, 8, 10, 12, 14, 16, 19, 21, 24, 27, 30};
static const NekDouble NodalTriElecData[][6] = {

    // %%% n_1 n_3 n_6 l_1 l_2 l_3
    // 1 1 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    // 2 2 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    // 3 3 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.7236067977, 0.2763932023, 0.0000000000},
    {1, 0, 0, 0.3333333333, 0.3333333333, 0.3333333333},
    // 4 4 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.8273268354, 0.1726731646, 0.0000000000},
    {0, 1, 0, 0.2371200168, 0.2371200168, 0.5257599664},
    // 5 5 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.6426157582, 0.3573842418, 0.0000000000},
    {0, 0, 1, 0.8825276620, 0.1174723380, 0.0000000000},
    {0, 1, 0, 0.4105151510, 0.4105151510, 0.1789696980},
    {0, 1, 0, 0.1575181512, 0.1575181512, 0.6849636976},
    // 6 7 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.7344243967, 0.2655756033, 0.0000000000},
    {0, 0, 1, 0.9151119481, 0.0848880519, 0.0000000000},
    {1, 0, 0, 0.3333333333, 0.3333333333, 0.3333333333},
    {0, 1, 0, 0.1061169285, 0.1061169285, 0.7877661430},
    {0, 0, 1, 0.3097982151, 0.5569099204, 0.1332918645},
    // 7 8 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.9358700743, 0.0641299257, 0.0000000000},
    {0, 0, 1, 0.7958500907, 0.2041499093, 0.0000000000},
    {0, 0, 1, 0.6046496090, 0.3953503910, 0.0000000000},
    {0, 0, 1, 0.2325524777, 0.6759625951, 0.0914849272},
    {0, 1, 0, 0.4477725053, 0.4477725053, 0.1044549894},
    {0, 1, 0, 0.2604038024, 0.2604038024, 0.4791923952},
    {0, 1, 0, 0.0660520784, 0.0660520784, 0.8678958432},
    // 8 10 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.9498789977, 0.0501210023, 0.0000000000},
    {0, 0, 1, 0.8385931398, 0.1614068602, 0.0000000000},
    {0, 0, 1, 0.6815587319, 0.3184412681, 0.0000000000},
    {0, 1, 0, 0.3905496216, 0.3905496216, 0.2189007568},
    {0, 1, 0, 0.2033467796, 0.2033467796, 0.5933064408},
    {0, 1, 0, 0.0469685351, 0.0469685351, 0.9060629298},
    {0, 0, 1, 0.3617970895, 0.5541643672, 0.0840385433},
    {0, 0, 1, 0.1801396087, 0.7519065566, 0.0679538347},
    // 9 12 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.9597669541, 0.0402330459, 0.0000000000},
    {0, 0, 1, 0.8693869326, 0.1306130674, 0.0000000000},
    {0, 0, 1, 0.7389624749, 0.2610375251, 0.0000000000},
    {0, 0, 1, 0.5826394788, 0.4173605212, 0.0000000000},
    {1, 0, 0, 0.3333333333, 0.3333333333, 0.3333333333},
    {0, 1, 0, 0.4640303025, 0.4640303025, 0.0719393950},
    {0, 1, 0, 0.1633923069, 0.1633923069, 0.6732153862},
    {0, 1, 0, 0.0355775717, 0.0355775717, 0.9288448566},
    {0, 0, 1, 0.3225890045, 0.4968009397, 0.1806100558},
    {0, 0, 1, 0.2966333890, 0.6349633653, 0.0684032457},
    {0, 0, 1, 0.1439089974, 0.8031490682, 0.0529419344},
    // 10 14 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.9670007152, 0.0329992848, 0.0000000000},
    {0, 0, 1, 0.8922417368, 0.1077582632, 0.0000000000},
    {0, 0, 1, 0.7826176635, 0.2173823365, 0.0000000000},
    {0, 0, 1, 0.6478790678, 0.3521209322, 0.0000000000},
    {0, 1, 0, 0.4232062312, 0.4232062312, 0.1535875376},
    {0, 1, 0, 0.2833924371, 0.2833924371, 0.4332151258},
    {0, 1, 0, 0.1330857076, 0.1330857076, 0.7338285848},
    {0, 1, 0, 0.0265250690, 0.0265250690, 0.9469498620},
    {0, 0, 1, 0.3934913008, 0.5472380443, 0.0592706549},
    {0, 0, 1, 0.2707097521, 0.5811217960, 0.1481684519},
    {0, 0, 1, 0.2462883939, 0.6991456238, 0.0545659823},
    {0, 0, 1, 0.1163195333, 0.8427538829, 0.0409265838},
    // 11 16 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.9724496361, 0.0275503639, 0.0000000000},
    {0, 0, 1, 0.9096396608, 0.0903603392, 0.0000000000},
    {0, 0, 1, 0.8164380765, 0.1835619235, 0.0000000000},
    {0, 0, 1, 0.6997654705, 0.3002345295, 0.0000000000},
    {0, 0, 1, 0.5682764664, 0.4317235336, 0.0000000000},
    {0, 1, 0, 0.4746683133, 0.4746683133, 0.0506633734},
    {0, 1, 0, 0.3764778430, 0.3764778430, 0.2470443140},
    {0, 1, 0, 0.2422268680, 0.2422268680, 0.5155462640},
    {0, 1, 0, 0.1104863580, 0.1104863580, 0.7790272840},
    {0, 1, 0, 0.0204278105, 0.0204278105, 0.9591443790},
    {0, 0, 1, 0.3649298091, 0.5060795425, 0.1289906484},
    {0, 0, 1, 0.3361965758, 0.6146545276, 0.0491488966},
    {0, 0, 1, 0.2299163838, 0.6466193522, 0.1234642640},
    {0, 0, 1, 0.2073828199, 0.7483396985, 0.0442774816},
    {0, 0, 1, 0.0959885136, 0.8715407373, 0.0324707491},
    // 12 19 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.9766549233, 0.0233450767, 0.0000000000},
    {0, 0, 1, 0.9231737823, 0.0768262177, 0.0000000000},
    {0, 0, 1, 0.8430942345, 0.1569057655, 0.0000000000},
    {0, 0, 1, 0.7414549105, 0.2585450895, 0.0000000000},
    {0, 0, 1, 0.6246434651, 0.3753565349, 0.0000000000},
    {1, 0, 0, 0.3333333333, 0.3333333333, 0.3333333333},
    {0, 1, 0, 0.4452623516, 0.4452623516, 0.1094752968},
    {0, 1, 0, 0.2091994115, 0.2091994115, 0.5816011770},
    {0, 1, 0, 0.0156346170, 0.0156346170, 0.9687307660},
    {0, 1, 0, 0.0926054449, 0.0926054449, 0.8147891102},
    {0, 0, 1, 0.4145270405, 0.5430117044, 0.0424612551},
    {0, 0, 1, 0.3292603428, 0.4567841256, 0.2139555316},
    {0, 0, 1, 0.3177076680, 0.5753716491, 0.1069206829},
    {0, 0, 1, 0.2890538328, 0.6707932601, 0.0401529071},
    {0, 0, 1, 0.1969473706, 0.6989024696, 0.1041501598},
    {0, 0, 1, 0.1765067641, 0.7877603302, 0.0357329057},
    {0, 0, 1, 0.0799959921, 0.8942989924, 0.0257050155},
    // 13 21 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.9799675226, 0.0200324774, 0.0000000000},
    {0, 0, 1, 0.9339005269, 0.0660994731, 0.0000000000},
    {0, 0, 1, 0.8644342995, 0.1355657005, 0.0000000000},
    {0, 0, 1, 0.7753197015, 0.2246802985, 0.0000000000},
    {0, 0, 1, 0.6713620067, 0.3286379933, 0.0000000000},
    {0, 0, 1, 0.5581659344, 0.4418340656, 0.0000000000},
    {0, 1, 0, 0.0125158559, 0.0125158559, 0.9749682882},
    {0, 1, 0, 0.4814041934, 0.4814041934, 0.0371916132},
    {0, 1, 0, 0.0791069148, 0.0791069148, 0.8417861704},
    {0, 1, 0, 0.1831015613, 0.1831015613, 0.6337968774},
    {0, 1, 0, 0.4068245409, 0.4068245409, 0.1863509182},
    {0, 1, 0, 0.2954002632, 0.2954002632, 0.4091994736},
    {0, 0, 1, 0.3944786597, 0.5151527485, 0.0903685918},
    {0, 0, 1, 0.3615540438, 0.6022119116, 0.0362340446},
    {0, 0, 1, 0.2767319260, 0.6304802457, 0.0927878283},
    {0, 0, 1, 0.2513189999, 0.7149811088, 0.0336998913},
    {0, 0, 1, 0.1706952037, 0.7399484931, 0.0893563032},
    {0, 0, 1, 0.1523482839, 0.8179762698, 0.0296754463},
    {0, 0, 1, 0.2915934740, 0.5215057084, 0.1869008176},
    {0, 0, 1, 0.0680753374, 0.9108476566, 0.0210770060},
    // 14 24 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.9826229633, 0.0173770367, 0.0000000000},
    {0, 0, 1, 0.9425410221, 0.0574589779, 0.0000000000},
    {0, 0, 1, 0.8817598450, 0.1182401550, 0.0000000000},
    {0, 0, 1, 0.8031266027, 0.1968733973, 0.0000000000},
    {0, 0, 1, 0.7103190274, 0.2896809726, 0.0000000000},
    {0, 0, 1, 0.6076769777, 0.3923230223, 0.0000000000},
    {0, 1, 0, 0.4587977340, 0.4587977340, 0.0824045320},
    {0, 1, 0, 0.3671908093, 0.3671908093, 0.2656183814},
    {0, 1, 0, 0.2595748224, 0.2595748224, 0.4808503552},
    {0, 1, 0, 0.1603773315, 0.1603773315, 0.6792453370},
    {0, 1, 0, 0.0685768901, 0.0685768901, 0.8628462198},
    {0, 1, 0, 0.0103478215, 0.0103478215, 0.9793043570},
    {0, 0, 1, 0.9234057833, 0.0588664441, 0.0177277726},
    {0, 0, 1, 0.8416660290, 0.1330619104, 0.0252720607},
    {0, 0, 1, 0.7721478696, 0.1494014554, 0.0784506750},
    {0, 0, 1, 0.7521462903, 0.2191316332, 0.0287220764},
    {0, 0, 1, 0.6781794781, 0.2494595411, 0.0723609808},
    {0, 0, 1, 0.6425344401, 0.3256595455, 0.0318060144},
    {0, 0, 1, 0.5834887797, 0.2550816171, 0.1614296032},
    {0, 0, 1, 0.5652822600, 0.3505856755, 0.0841320645},
    {0, 0, 1, 0.5379997781, 0.4292596705, 0.0327405513},
    {0, 0, 1, 0.4692799339, 0.3610693351, 0.1696507310},
    // 15 27 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 0, 1, 0.9847840231, 0.0152159769, 0.0000000000},
    {0, 0, 1, 0.9496002665, 0.0503997335, 0.0000000000},
    {0, 0, 1, 0.8960041459, 0.1039958541, 0.0000000000},
    {0, 0, 1, 0.8261943514, 0.1738056486, 0.0000000000},
    {0, 0, 1, 0.7430297109, 0.2569702891, 0.0000000000},
    {0, 0, 1, 0.6499152345, 0.3500847655, 0.0000000000},
    {0, 0, 1, 0.5506631368, 0.4493368632, 0.0000000000},
    {1, 0, 0, 0.3333333333, 0.3333333333, 0.3333333333},
    {0, 1, 0, 0.4852528832, 0.4852528832, 0.0294942336},
    {0, 1, 0, 0.4255990820, 0.4255990820, 0.1488018360},
    {0, 1, 0, 0.2320836842, 0.2320836842, 0.5358326316},
    {0, 1, 0, 0.1405179457, 0.1405179457, 0.7189641086},
    {0, 1, 0, 0.0599963506, 0.0599963506, 0.8800072988},
    {0, 1, 0, 0.0085857218, 0.0085857218, 0.9828285564},
    {0, 0, 1, 0.9337196169, 0.0512926813, 0.0149877018},
    {0, 0, 1, 0.8617284617, 0.1169291070, 0.0213424313},
    {0, 0, 1, 0.8006726315, 0.1325472687, 0.0667800998},
    {0, 0, 1, 0.7794706504, 0.1957424109, 0.0247869387},
    {0, 0, 1, 0.7134213061, 0.2207559648, 0.0658227291},
    {0, 0, 1, 0.6834546988, 0.2890601702, 0.0274851310},
    {0, 0, 1, 0.6286428956, 0.2270147509, 0.1443423535},
    {0, 0, 1, 0.6135939037, 0.3123505510, 0.0740555453},
    {0, 0, 1, 0.5886608293, 0.3824865582, 0.0288526124},
    {0, 0, 1, 0.5244220875, 0.3265860871, 0.1489918254},
    {0, 0, 1, 0.5171616793, 0.4145995177, 0.0682388030},
    {0, 0, 1, 0.4324830342, 0.3299898010, 0.2375271649},
    // 16 30 %%% Order / Number of Points
    {0, 2, 0, 1.0000000000, 0.0000000000, 0.0000000000},
    {0, 1, 0, 0.5000000000, 0.5000000000, 0.0000000000},
    {0, 0, 1, 0.9865660883, 0.0134339117, 0.0000000000},
    {0, 0, 1, 0.9554399980, 0.0445600020, 0.0000000000},
    {0, 0, 1, 0.9078481256, 0.0921518744, 0.0000000000},
    {0, 0, 1, 0.8455144903, 0.1544855097, 0.0000000000},
    {0, 0, 1, 0.7706926997, 0.2293073003, 0.0000000000},
    {0, 0, 1, 0.6860872168, 0.3139127832, 0.0000000000},
    {0, 0, 1, 0.5947559868, 0.4052440132, 0.0000000000},
    {0, 1, 0, 0.4692881367, 0.4692881367, 0.0614237267},
    {0, 1, 0, 0.3932305456, 0.3932305456, 0.2135389089},
    {0, 1, 0, 0.3025577746, 0.3025577746, 0.3948844509},
    {0, 1, 0, 0.2078492229, 0.2078492229, 0.5843015542},
    {0, 1, 0, 0.1284932701, 0.1284932701, 0.7430134598},
    {0, 1, 0, 0.0529388222, 0.0529388222, 0.8941223556},
    {0, 1, 0, 0.0072437614, 0.0072437614, 0.9855124772},
    {0, 0, 1, 0.9419105656, 0.0452492885, 0.0128401458},
    {0, 0, 1, 0.8772044870, 0.1042200005, 0.0185755125},
    {0, 0, 1, 0.8214366546, 0.1173927115, 0.0611706338},
    {0, 0, 1, 0.8060459745, 0.1727546471, 0.0211993784},
    {0, 0, 1, 0.7464832409, 0.1959218281, 0.0575949309},
    {0, 0, 1, 0.7198500717, 0.2560058606, 0.0241440677},
    {0, 0, 1, 0.6657283975, 0.1263493158, 0.2079222867},
    {0, 0, 1, 0.6578452111, 0.2860606787, 0.0560941102},
    {0, 0, 1, 0.6256312013, 0.3487602527, 0.0256085459},
    {0, 0, 1, 0.5755509622, 0.2921362629, 0.1323127749},
    {0, 0, 1, 0.5620632423, 0.3743524772, 0.0635842805},
    {0, 0, 1, 0.5343544917, 0.4393591499, 0.0262863584},
    {0, 0, 1, 0.4883520007, 0.2978352313, 0.2138127680},
    {0, 0, 1, 0.4806452274, 0.3853613574, 0.1339934152}};

} // namespace LibUtilities
} // namespace Nektar
