/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

struct testtable {
	char		*tt_name;
	unsigned short	tt_port;
	int		(*tt_func)( struct test *, struct report * );
	char		*(*tt_init)( struct test * );
};

extern struct testtable	testtable[];

#define TESTPROTO(x)	int x( struct test *, struct report * )
#define INITPROTO(x)	char *x( struct test * )

TESTPROTO( test_shell );
TESTPROTO( test_sim );
TESTPROTO( test_tcp );
TESTPROTO( test_stcp );
TESTPROTO( test_pop );
TESTPROTO( test_imap );
TESTPROTO( test_ping );
TESTPROTO( test_up );
TESTPROTO( test_dns );
TESTPROTO( test_ntp );
TESTPROTO( test_http );
TESTPROTO( test_ipp );
TESTPROTO( test_ssh );
TESTPROTO( test_smtp );

INITPROTO( init_shell );
INITPROTO( init_ping );
INITPROTO( init_dns );
INITPROTO( init_http );
INITPROTO( init_ipp );
INITPROTO( init_ssh );
INITPROTO( init_noargs );

#ifdef HAVE_LDAP
TESTPROTO( test_ldap );
#endif
