/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/**********          ttable.c.in          **********/

#include <sys/types.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <stdio.h>

#include "nefu.h"
#include "config.h"
#include "ttable.h"

struct testtable testtable[] = {
	{ "ping",	0,	test_ping,	init_ping },
	{ "!",		0,	test_shell,	init_shell },
	{ "dns",	53,	test_dns, 	init_dns },
	{ "http",	80,	test_http,	init_http },
	{ "ipp",	631,	test_ipp,	init_ipp },
	{ "ssh",        22,     test_ssh,       init_ssh },
	{ "pop",	110,	test_pop,	init_noargs },
	{ "pop2",	109,	test_pop,	init_noargs },
	{ "pop3",	110,	test_pop,	init_noargs },
	{ "ntp",	123,	test_ntp,	init_noargs },
	{ "imap",	143,	test_imap,	init_noargs },
	{ "imsp",	406,	test_imap,	init_noargs },
	{ "tcp",	0,	test_tcp,	init_noargs },
	{ "telnet",	23,	test_tcp,	init_noargs },
	{ "finger",	79,	test_tcp,	init_noargs },
	{ "https",	443,	test_tcp,	init_noargs },
	{ "smtps",	465,	test_tcp,	init_noargs },
	{ "afp",	548,	test_tcp,	init_noargs },
	{ "imaps",	993,	test_tcp,	init_noargs },
	{ "pop3s",	995,	test_tcp,	init_noargs },
	{ "kpop",	1109,	test_tcp,	init_noargs },
	{ "sieve",	2000,	test_tcp,	init_noargs },
	{ "lmtp",	2003,	test_tcp,	init_noargs },
	{ "mupdate",	3905,	test_tcp,	init_noargs },
	{ "irc",	6667,	test_tcp,	init_noargs },
	{ "stcp",	0,	test_stcp,	init_noargs },
	{ "ftp",	21,	test_stcp,	init_noargs },
	{ "smtp",	25,	test_smtp,	init_noargs },
	{ "nntp",	119,	test_stcp,	init_noargs },
	{ "imapactl",	2004,	test_stcp,	init_noargs },
	{ "tpp",	6661,	test_stcp,	init_noargs },
#ifdef HAVE_LDAP
	{ "ldap",	389,	test_ldap,	init_noargs },
#endif
	{ NULL,		0,	NULL,		NULL },
};
