/*
 * Copyright (c) 1998 Regents of The University of Michigan.
 * All Rights Reserved.  See COPYRIGHT.
 */

/*********            report.c          **********/

#include <sys/time.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/wait.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>

#include <stdarg.h>
#include <stdio.h>
#include <syslog.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "nefu.h"

#define	SZ	10
#define	BUFLEN		256

char		*sendmailargv[] = { "sendmail", 0, "-odb", "-t", 0 };
int		nefu_suppress_reports = 0;

int	sendmail( int, struct test *, struct report *, struct report * );

    int
sendmail( type, t, r_now, r_prev )
    int			type;
    struct test		*t;
    struct report	*r_now;
    struct report	*r_prev;
{
    char		tobuf[ BUFLEN ];
    FILE		*fp;
    int			fd[ 2 ];
    int			totals = 0;
    int			status;
    int			pid;
    struct timeval	tv;
    char		*frombuf;

    if ( pipe( fd ) < 0 ) {
	syslog( LOG_ERR, "sendmail: pipe: %m" );
	return( -1 );
    }

    if ( t->t_rlist == NULL ) {
	sprintf( tobuf, "%s", nefu_uname );
    } else {
	/* XXX possible buffer overflow? */
	sprintf( tobuf, "%s", t->t_rlist );
    }

    switch ( pid = fork()) {
    case -1 :
	syslog( LOG_ERR, "sendmail: fork: %m" );
	return( -1 );

    case 0 :
	if ( close( fd[ 1 ] ) < 0 ) {
	    syslog( LOG_ERR, "sendmail: close: %m" );
	    return( -1 );
	}
	if ( dup2( fd[ 0 ], 0 ) < 0 ) {
	    syslog( LOG_ERR, "sendmail: dup2: %m" );
	    return( -1 );
	}
	if ( close( fd[ 0 ] ) < 0 ) {
	    syslog( LOG_ERR, "sendmail: close: %m" );
	    return( -1 );
	}
	if (( frombuf = (char*)malloc( strlen( nefu_from_addr ) + 3 ))
		== NULL ) {
	    syslog( LOG_ERR, "malloc: %m\n" );
	    return( -1 );
	}
	sprintf( frombuf, "-f%s", nefu_from_addr );
	sendmailargv[ 1 ] = frombuf;
	execv( nefu_sendmail, sendmailargv );
	/* if we are here, there is an error */
	syslog( LOG_ERR, "execv %s: %m\n", nefu_sendmail );
	exit( 1 );

    default :
	if ( close( fd[ 0 ] ) < 0 ) {
	    syslog( LOG_ERR, "sendmail: close: %m" );
	    return( -1 );
	}

	if (( fp = fdopen( fd[ 1 ], "w" )) == NULL ) {
	    syslog( LOG_ERR, "sendmail: fdopen: %m" );
	    return( -1 );
	}
	fprintf( fp, "To: %s\n", tobuf );
	fprintf( fp, "From: \"nefu-monitor\" <%s@%s>\n", nefu_from_addr,
		nefu_localdomain );
	fprintf( fp, "Subject: %s %s ", t->t_machine->m_name, t->t_full_name );

	if (( type & T_DOWN_MASK ) != 0 ) {
	    if (( t->t_status & T_DOWN_MASK ) == 0 ) {
		fprintf( fp, "DOWN\n\n" );

		if ( nefu_redundant_paging != 0 ) {
		    fprintf( fp, "nefu-monitor [%s]: %s %s DOWN\n", nefu_uname, 
			    t->t_machine->m_name, t->t_full_name );
		}

	    } else {
		tv = t->t_time_down;
		time_end( &tv );
		totals++;
		fprintf( fp, "NEW\n\n" );

		if ( nefu_redundant_paging != 0 ) {
		    fprintf( fp, "nefu-monitor [%s]: %s %s NEW\n", nefu_uname, 
			    t->t_machine->m_name, t->t_full_name );
		}
	    }

	    if (( r_now != NULL ) && ( *(r_now->r_buf) != '\0' )) {
		fprintf( fp, "%s\n", r_now->r_buf );
	    } else {
		fprintf( fp, "error unspecified\n" );
	    }

	    if ( t->t_report != NULL ) {
		fprintf( fp, "old: %s\n", t->t_report->r_buf );
	    }

	    if ( r_prev != NULL ) {
		fprintf( fp, "bounce: %s\n", r_prev->r_buf );
	    }

	} else {
	    tv = t->t_time_down;
	    time_end( &tv );
	    totals++;
	    fprintf( fp, "UP\n\n" );

	    if ( nefu_redundant_paging != 0 ) {
		fprintf( fp, "nefu-monitor [%s]: %s %s UP\n", nefu_uname, 
			t->t_machine->m_name, t->t_full_name );
	    }
	}

	if ( totals != 0 ) {
	    fprintf( fp, "time: %s\n", time_down( &tv ));
	    fprintf( fp, "pass: %ld\n", t->t_tested - t->t_pass_down );
	}

	fclose( fp );
	syslog( LOG_INFO, "sendmail confirmation to %s", tobuf );

	if (( waitpid( pid, &status, 0 ) < 0 ) && ( errno != ECHILD )) {
	    syslog( LOG_ERR, "waitpid: %m" );
	    exit( 1 );
	}

	if ( WIFEXITED( status )) {
	    if ( WEXITSTATUS( status )) {
		syslog( LOG_ERR, "sendmail %d exited with %d", pid,
			WEXITSTATUS( status ));
	    } else {
		syslog( LOG_INFO, "sendmail %d done", pid );
	    }
	} else if ( WIFSIGNALED( status )) {
	    syslog( LOG_ERR, "sendmail %d died on signal %d", pid,
		    WTERMSIG( status ));
	} else {
	    syslog( LOG_ERR, "sendmail %d died", pid );
	}
    }

    return( 0 );
}


    int
report( type, t, r_now, r_prev )
	int type;
	struct test *t;
	struct report *r_now;
	struct report *r_prev;
{
    struct timeval	tv;

    if ( type == R_BOUNCE ) {
	syslog( LOG_NOTICE, "%s %s %s BOUNCE %s",
		t->t_rlist, t->t_machine->m_name, t->t_full_name,
		r_now->r_buf );
	return( 0 );
    } else {
	/* type of transition */

	if (( type & T_DOWN_MASK ) != 0 ) {
	    if ( t->t_status == T_UP ) {
		syslog( LOG_NOTICE, "%s %s %s UP->DOWN %s",
			t->t_rlist, t->t_machine->m_name, t->t_full_name,
			r_now->r_buf );
	    } else {
		tv = t->t_time_down;
		time_end( &tv );

		syslog( LOG_NOTICE, "%s %s %s NEW %s %ld %s",
			t->t_rlist, t->t_machine->m_name, t->t_full_name,
			time_down( &tv ), t->t_tested - t->t_pass_down,
			r_now->r_buf );
	    }

	} else {
	    tv = t->t_time_down;
	    time_end( &tv );
	    syslog( LOG_NOTICE, "%s %s %s DOWN->UP %s %ld",
		    t->t_rlist, t->t_machine->m_name, t->t_full_name,
		    time_down( &tv ), t->t_tested - t->t_pass_down );
	}

	if ( nefu_suppress_reports == 0 ) {
	    return( sendmail( type, t, r_now, r_prev ));
	}
    }
}

    int
report_space( struct report *r, int len )
{
    char	*p;
    int		sz;

    if ( r->r_cur + len >= r->r_end ) {
	if ( r->r_buf == NULL ) {
	    if (( p = (char *)malloc( SZ )) == NULL ) {
		syslog( LOG_ERR, "malloc: %m\n" );
		return( -1 );
	    }
	    r->r_len = SZ;
	} else {
	    sz = SZ * ( 1 + ( len / SZ ));
	    if (( p = (char *)realloc( r->r_buf, r->r_len + sz )) == NULL ) {
		*r->r_cur = '\0';
		return( -1 );
	    }
	    r->r_len += sz;
	}
	r->r_cur = ( r->r_cur - r->r_buf ) + p;
	r->r_buf = p;
	r->r_end = r->r_buf + r->r_len;
    }

    return( 0 );
}

    /* this mallocs and returns appropriate space for the reporst structure */

    struct report*
report_create()
{
    struct report	*r;

    if ( reports != NULL ) {
	r = reports;
	reports = r->r_next;
	return( r );
    }

    if (( r = (struct report*)malloc( sizeof( struct report ))) == NULL ) {
	syslog( LOG_ERR, "malloc: %m\n" );
	return( NULL );
    }

    r->r_buf = NULL;
    r->r_len = 0;
    r->r_cur = r->r_buf;
    r->r_end = r->r_buf + r->r_len;
    r->r_next = NULL;

    if ( report_space( r, 1 ) != 0 ) {
	return( NULL );
    }

    return( r );
}

/*
 * Just like fprintf, only writes to the report struct
 *
 * Todo: %c, %f, *, . and, -
 */
    int
#ifdef __STDC__
report_printf( struct report *r, char *fmt, ... )
#else /* __STDC__ */
report_printf( struct report *r, char *fmt, va_alist )
    struct report	*r;
    char		*fmt;
    va_dcl
#endif /* __STDC__ */
{
    va_list		vl;
    char		*s, *p;
    char		dbuf[ 1024 ], *dbufoff = dbuf + sizeof( dbuf );
    int			d, len;

#ifdef __STDC__
    va_start( vl, fmt );
#else /* __STDC__ */
    va_start( vl );
#endif /* __STDC__ */

    r->r_cur = r->r_buf;
    r->r_end = r->r_buf + r->r_len;

    for ( ; *fmt; fmt++ ) {
	if ( *fmt == '%' ) {
	    switch ( *( fmt + 1 )) {
	    case 's' :
		s = va_arg( vl, char * );
		len = strlen( s );

		if ( report_space( r, len ) < 0 ) {
		    return( -1 );
		}

		strncpy( r->r_cur, s, len );
		r->r_cur += len;
		break;

	    case 'm' :
		s = strerror( errno );
		len = strlen( s );

		if ( report_space( r, len ) < 0 ) {
		    return( -1 );
		}

		strncpy( r->r_cur, s, len );
		r->r_cur += len;
		break;

	    case 'd' :
		d = va_arg( vl, int );
		p = dbufoff;
		while ( d ) {
		    if ( --dbufoff < dbuf ) {
			if ( report_space( r, 1 ) < 0 ) {
			    return( -1 );
			}
			*r->r_cur = '\0';
			return( -1 );
		    }
		    *dbufoff = '0' + ( d % 10 );
		    d /= 10;
		}

		if ( report_space( r, p - dbufoff ) < 0 ) {
		    return( -1 );
		}
		strncpy( r->r_cur, dbufoff, p - dbufoff );
		r->r_cur += p - dbufoff;
		dbufoff = p;
		break;

	    case '%' :
		if ( report_space( r, 1 ) < 0 ) {
		    return( -1 );
		}
		*r->r_cur++ = '%';
		break;

	    default :
		if ( report_space( r, 2 ) < 0 ) {
		    return( -1 );
		}
		*r->r_cur++ = '%';
		*r->r_cur++ = *( fmt + 1 );
		break;
	    }

	    fmt++;

	} else {
	    if ( report_space( r, 1 ) < 0 ) {
		return( -1 );
	    }
	    *r->r_cur++ = *fmt;
	}
    }

    if ( report_space( r, 1 ) < 0 ) {
	return( -1 );
    }
    *r->r_cur = '\0';

    va_end( vl );

    return ( r->r_cur - r->r_buf );
}

    void
report_free( struct report *r )
{
    if ( r == NULL ) {
	syslog( LOG_ERR, "report_free: panic!" );
	abort();
    }

    r->r_next = reports;
    reports = r;

    if ( r->r_buf != NULL ) {
	*(r->r_buf) = '\0';
    }
    r->r_cur = r->r_buf;
    r->r_end = r->r_buf + r->r_len;
    return;
}
