/*********         tcptest.c         **********/

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <stdio.h>
#include <syslog.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include <unistd.h>
#include <errno.h>

#include <snet.h>

#include "nefu.h"

#define	TIME		120	/* rfc 821 default time */


    char *
init_noargs( struct test *t )
{

    if ( t->t_argc > 0 ) {
	return( "no args allowed" );
    }

    return( NULL );
}


    int
test_tcp( struct test *t, struct report *r )
{
    int			s;
    int			result = T_UP;

    if (( s = socket( AF_INET, SOCK_STREAM, 0 )) < 0 ) {
	report_printf( r, "socket: %m" );
	return( T_MAYBE_DOWN );
    }

    if ( connect( s, (struct sockaddr *)&t->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	if ( errno == ECONNREFUSED ) {
	    result = T_DOWN;
	} else {
	    result = T_MAYBE_DOWN;
	}
	report_printf( r, "%m" );
	goto done;
    }

done:
    close( s );
    return( result );
}


    char *
stcp_reply( SNET *n, struct timeval *tv )
{
    char	*line;

    do {
	if (( line = snet_getline( n, tv )) == NULL ) {
	    return( NULL );
	}
	if ( strlen( line ) < 4 ) {
	    return( "Short line" );
	}
    } while( *( line + 3 ) == '-' );

    return( line );
}


    int
test_stcp( struct test *t, struct report *r )
{
    int			s;
    int			result = T_UP;
    SNET		*n;
    struct timeval	tv;
    char		*p;
    int			maxwait;

    if (( s = socket( AF_INET, SOCK_STREAM, 0 )) < 0 ) {
	report_printf( r, "socket: %m" );
	return( T_MAYBE_DOWN );
    }

    if ( connect( s, (struct sockaddr *)&t->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	if ( errno == ECONNREFUSED ) {
	    result = T_DOWN;
	} else {
	    result = T_MAYBE_DOWN;
	}
	report_printf( r, "%m" );
	goto done;
    }

    if (( n = snet_attach( s, 10240 )) == NULL ) {
	report_printf( r, "snet_attach: %m" );
	result = T_MAYBE_DOWN;
	goto done;
    }

    maxwait = TIME;
    if (( nefu_test_maxwait >= 0 ) && ( maxwait > nefu_test_maxwait )) {
	maxwait = nefu_test_maxwait;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( p = stcp_reply( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( *p != '2' ) {
	report_printf( r, "%s", p );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    if ( snet_writef( n, "QUIT\r\n" ) < 0 ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( p = stcp_reply( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( *p != '2' ) {
	report_printf( r, "%s", p );
	result = T_MAYBE_DOWN;
	goto done2;
    }

done2:
    snet_close( n );
done:
    close( s );
    return( result );
}


    int
test_smtp( struct test *t, struct report *r )
{
    int			s;
    int			result = T_UP;
    SNET		*n;
    struct timeval	tv;
    char		*p;
    int			maxwait;

    if (( s = socket( AF_INET, SOCK_STREAM, 0 )) < 0 ) {
	report_printf( r, "socket: %m" );
	return( T_MAYBE_DOWN );
    }

    if ( connect( s, (struct sockaddr *)&t->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	if ( errno == ECONNREFUSED ) {
	    result = T_DOWN;
	} else {
	    result = T_MAYBE_DOWN;
	}
	report_printf( r, "%m" );
	goto done;
    }

    if (( n = snet_attach( s, 10240 )) == NULL ) {
	report_printf( r, "snet_attach: %m" );
	result = T_MAYBE_DOWN;
	goto done;
    }

    maxwait = TIME;
    if (( nefu_test_maxwait >= 0 ) && ( maxwait > nefu_test_maxwait )) {
	maxwait = nefu_test_maxwait;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( p = stcp_reply( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( *p != '2' ) {
	report_printf( r, "%s", p );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    if ( snet_writef( n, "HELO %s\r\n", nefu_localdomain ) < 0 ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;
    if (( p = stcp_reply( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( *p != '2' ) {
	report_printf( r, "%s", p );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    if ( snet_writef( n, "MAIL FROM:<%s@%s>\r\n", nefu_uname,
	    nefu_localdomain ) < 0 ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;
    if (( p = stcp_reply( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( *p != '2' ) {
	report_printf( r, "%s", p );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    if ( snet_writef( n, "QUIT\r\n" ) < 0 ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;
    if (( p = stcp_reply( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( *p != '2' ) {
	report_printf( r, "%s", p );
	result = T_MAYBE_DOWN;
	goto done2;
    }

done2:
    snet_close( n );
done:
    close( s );
    return( result );
}
