#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>
 
#include <netdb.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>
#include <memory.h>
#include <unistd.h>
#include <strings.h>

#include "snet.h"
#include "nefu.h"

#define SSH_MAXLEN           1024                   /* buffer size  */
#define SSH_VERSIONSTRING    "SSH-2.00-NEFU_SSH_Version_Mapper\n" 
#define SSH_TIMEOUT_DEFAULT  30
#define SSH_USAGE            "usage: ssh [timeout in seconds]"


    char * 
init_ssh( struct test * t)
{
    if ( t->t_argc > 1 ) {
        return ( SSH_USAGE );        
    }

    return ( NULL ); 
}


    int 
test_ssh( struct test *t, struct report *r )
{
    int               sockfd;
    int               state;
    SNET              *n;
    char              *buf;
    struct timeval    timeout;

    if ( t->t_argc == 1 ) {
        timeout.tv_sec = atoi( t->t_argv[0] );
    } else {
        timeout.tv_sec = SSH_TIMEOUT_DEFAULT ;

	if (( nefu_test_maxwait >= 0 ) &&
		( timeout.tv_sec > nefu_test_maxwait )) {
	    timeout.tv_sec = nefu_test_maxwait;
	}
    }
 
    timeout.tv_usec = 0;

    /* Open the socket and then connect  */
    if (( sockfd = socket( AF_INET, SOCK_STREAM, 0 )) == -1 ) {
        report_printf( r, "socket: %m" );
        return ( T_MAYBE_DOWN );
    }

    if ( connect( sockfd, (struct sockaddr *)&t->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	if ( errno == ECONNREFUSED ) {
	    state = T_DOWN;
	} else {
	    state = T_MAYBE_DOWN;
	}
	report_printf( r, "%m" );
	close( sockfd );
	return( state );
    }

    /* Get the identification string from the server */
    if (( n = snet_attach( sockfd, SSH_MAXLEN )) == NULL ) {
         report_printf( r, "snet_attach: %m" );
         if ( snet_close( n ) != 0 ) {
             report_printf( r, "snet_close: %m" );
         }
         return ( T_MAYBE_DOWN );
    }

    if (( buf = snet_getline( n, &timeout )) == NULL ) {
         report_printf( r, "snet_getline: %m" );
         if ( snet_close( n )) {
             report_printf( r, "snet_close: %m" );
         }
         return ( T_DOWN );
    }
      
    if ( strncmp( buf, "SSH-", 4 )) {
        report_printf( r, "invalid response" );
        if ( snet_close( n ) != 0 ) {
            report_printf( r, "snet_close: %m" );
        }
        return ( T_DOWN );
    }

    /* send identification string to the server */
    if ( snet_writef( n, SSH_VERSIONSTRING ) <= 0 ) {
        report_printf( r, "snet_writef: %m" );
        if ( snet_close( n ) != 0 ) {
            report_printf( r, "snet_close: %m" );
        }
        return ( T_DOWN );
    }

    if ( snet_close( n ) != 0 ) {
        report_printf( r, "snet_close: %m" );
        return ( T_MAYBE_DOWN );
    }

    return ( T_UP );
}
