/*********         pop.c         **********/

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <syslog.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>

#include <snet.h>

#include "nefu.h"

#define	TIME		120


    int
test_pop( struct test *t, struct report *r )
{
    int			maxwait;
    int			s;
    int			result = T_UP;
    SNET		*n;
    struct timeval	tv;
    char		*line;
    char		*plusok = "+OK";
    int			lenplusok = strlen( plusok );

    if (( s = socket( AF_INET, SOCK_STREAM, 0 )) < 0 ) {
	report_printf( r, "socket: %m" );
	return( T_MAYBE_DOWN );
    }

    if ( connect( s, (struct sockaddr *)&t->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	report_printf( r, "%m" );
	if ( errno == ECONNREFUSED ) {
	    result = T_DOWN;
	} else {
	    result = T_MAYBE_DOWN;
	}
	goto done;
    }

    if (( n = snet_attach( s, 10240 )) == NULL ) {
	report_printf( r, "snet_attach: %m" );
	result = T_MAYBE_DOWN;
	goto done;
    }

    maxwait = TIME;

    if (( nefu_test_maxwait >= 0 ) && ( maxwait > nefu_test_maxwait )) {
	maxwait = nefu_test_maxwait;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( nefu_test_maxwait >= 0 ) && ( tv.tv_sec > nefu_test_maxwait )) {
	tv.tv_sec = nefu_test_maxwait;
    }

    if (( line = snet_getline( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( strncmp( line, plusok, lenplusok ) != 0 ) {
	report_printf( r, "%s", line );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    if ( snet_writef( n, "QUIT\r\n" ) < 0 ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;
    if (( line = snet_getline( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( strncmp( line, plusok, lenplusok ) != 0 ) {
	report_printf( r, "%s", line );
	result = T_MAYBE_DOWN;
	goto done2;
    }

done2:
    snet_close( n );
done:
    close( s );
    return( result );
}
