/***********      ping.c      ***********/

#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <netinet/in_systm.h>
#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <arpa/inet.h>

#include <netdb.h>
#include <ctype.h>
#include <stdio.h>
#include <fcntl.h>
#include <stdlib.h>
#include <syslog.h>
#include <errno.h>
#include <memory.h>
#include <unistd.h>
#include <strings.h>

#include "nefu.h"

#define ATTEMPTS		3	/* three tries default */
#define TIME			1	/* one sec plenty for default */
#define ICMP_SIZE		8	/* rfc 1885 page 14 */
#define SIZEOF_TIMEVAL		8	/* as per sizeof call */
#define SIZEOF_IP_HEAD		20	/* as per sizeof call */
#define	MESSAGE			"nefu was here!"	/* not kilroy */
#define MESSAGE_LEN		strlen( MESSAGE ) + 1
#define	SEND_MESSAGE_OFFSET	ICMP_SIZE + SIZEOF_TIMEVAL
#define	RECV_MESSAGE_OFFSET	SEND_MESSAGE_OFFSET + SIZEOF_IP_HEAD
#define SEND_PACKET_SIZE	ICMP_SIZE + SIZEOF_TIMEVAL +MESSAGE_LEN
#define RECV_PACKET_SIZE	SEND_PACKET_SIZE + SIZEOF_IP_HEAD
#define USAGE			"useage: ping [ seconds ]"

/*
 * in_cksum --
 *	Checksum routine for Internet Protocol family headers (C Version)
 */
    static int
in_cksum( u_short *addr, int len )
{
	register int nleft = len;
	register u_short *w = addr;
	register int sum = 0;
	u_short answer = 0;

	/*
	 * Our algorithm is simple, using a 32 bit accumulator (sum), we add
	 * sequential 16 bit words to it, and at the end, fold back all the
	 * carry bits from the top 16 bits into the lower 16 bits.
	 */
	while (nleft > 1)  {
		sum += *w++;
		nleft -= 2;
	}

	/* mop up an odd byte, if necessary */
	if (nleft == 1) {
		*(u_char *)(&answer) = *(u_char *)w ;
		sum += answer;
	}

	/* add back carry outs from top 16 bits to low 16 bits */
	sum = (sum >> 16) + (sum & 0xffff);	/* add hi 16 to low 16 */
	sum += (sum >> 16);			/* add carry */
	answer = ~sum;				/* truncate to 16 bits */
	return(answer);
}


    char *
init_ping( struct test *t )
{
    char		*c;

    switch ( t->t_argc ) {
    case 1:
	for ( c = t->t_argv[ 0 ]; *c != '\0'; c++ ) {
	    if ( isdigit( *c ) == 0 ) {
		return( USAGE );
	    }
	}

	if ( atoi( t->t_argv[ 0 ]) < 0 ) {
	    return( USAGE );
	}
    case 0:
	break;

    default:
	return( USAGE );
    }

    return( NULL );
}
    

    int
test_ping( struct test *t, struct report *r )
{
    static u_int	sequence_number = 1;
    struct timeval	tv_remain;	/* time until select time out */
    struct timeval	tv_timeout;
    struct timeval	tv_wait;
    fd_set		readfds;
    int			attempts;
    int			send_wrote;	/* how much did sendto write? */
    int			recv_read;	/* how much did recvfrom read? */
    int			attempt;
    int			pid;
    int			fromlen;
    int			readyfds;
    int			same_host = 0;

    /* these are the packets, and pointers in to the packets */

    struct icmp		*icmp_send;
    struct icmp		*icmp_recv;
    u_char		packet_send[ SEND_PACKET_SIZE ]; /* packet to send */
    u_char		packet_recv[ RECV_PACKET_SIZE ]; /* packet to recv */
    struct timeval	*tv_send;	/* area that stores time we sent it */
    struct timeval	*tv_recv;	/* area that stores time we sent it */
    char		*send_message;	/* message we send */
    char		*recv_message;	/* message we recv */
    struct sockaddr_in	sin_recv;	/* should be our address */
    struct ip		*ip_recv;

    attempts = ATTEMPTS;
    tv_timeout.tv_sec = TIME;
    tv_timeout.tv_usec = 0;

    if (( nefu_test_maxwait >= 0 ) &&
	    ( tv_timeout.tv_sec > nefu_test_maxwait )) {
	tv_timeout.tv_sec = nefu_test_maxwait;
    }

    /* useage: ping [ seconds ] */
    switch ( t->t_argc ) {
    case 1:
	if (( tv_timeout.tv_sec = atoi( t->t_argv[ 0 ])) == 0 ) {
	    return( T_UP );
	}
    case 0:
	break;

    default:
	report_printf( r, USAGE );
	return( T_DOWN );
    }


    if (( pid = getpid()) < 0 ) {
	report_printf( r, "getpid: %m" );
	return( T_MAYBE_DOWN );
    }

    fromlen = sizeof( struct sockaddr_in );

    /* set up packets */

    ip_recv = (struct ip *)packet_recv;

    icmp_send = (struct icmp *)packet_send;
    icmp_send->icmp_type = ICMP_ECHO;
    icmp_send->icmp_id = pid;	/* reasonably unique key */

    icmp_recv = (struct icmp *)(packet_recv + SIZEOF_IP_HEAD );

    tv_send = (struct timeval *)(packet_send + ICMP_SIZE );
    tv_recv = (struct timeval *)(packet_recv + ICMP_SIZE + SIZEOF_IP_HEAD );

    send_message = (char *)(packet_send + SEND_MESSAGE_OFFSET );
    recv_message = (char *)(packet_recv + RECV_MESSAGE_OFFSET );

    strcpy( send_message, MESSAGE );

    /* try to send the packets */
    for ( attempt = 0; attempt < attempts; attempt++ ) {

	icmp_send->icmp_seq = sequence_number;
	sequence_number++;

	tv_remain = tv_timeout;

	/* get time of day for packet */
	if ( time_start( tv_send ) < 0 ) {
	    report_printf( r, "time_start %m" );
	    return( T_MAYBE_DOWN );
	}

	icmp_send->icmp_cksum = 0;

	icmp_send->icmp_cksum = in_cksum((u_short *)icmp_send,
		SEND_PACKET_SIZE );

	if (( send_wrote = sendto( nefu_raw_socket, (char *)icmp_send,
		SEND_PACKET_SIZE, 0, (struct sockaddr *)&t->t_sin,
		sizeof( struct sockaddr_in ))) < 0 ) {
	    report_printf( r, "sendto: %m" );
	    return( T_MAYBE_DOWN );
	}

	while(( tv_remain.tv_sec > 0 ) || ( tv_remain.tv_usec > 0 )) {

	    FD_ZERO( &readfds );
	    FD_SET( nefu_raw_socket, &readfds );

	    /* get start time */
	    if ( time_start( &tv_wait ) < 0 ) {
		report_printf( r, "time_start %m" );
		return( T_MAYBE_DOWN );
	    }

	    if (( readyfds = select( nefu_raw_socket + 1, &readfds, NULL, NULL,
		    &tv_remain )) < 0 ) {
		report_printf( r, "select: %m" );
		return( T_MAYBE_DOWN );

	    } else if ( readyfds == 0 ) {
		/* socket NOT ready to be read, and timed out */
		break;

	    } else {
		if ( time_end( &tv_wait ) < 0 ) {
		    report_printf( r, "time_end: %m" );
		    return( T_MAYBE_DOWN );
		}

		if ( time_minus( &tv_remain, &tv_wait ) < 0 ) {
		    break;
		}

		if (( tv_remain.tv_sec == 0 ) && ( tv_remain.tv_usec == 0 )) {
		    break;
		}

		/* read the damn socket */
		if (( recv_read = recvfrom( nefu_raw_socket, packet_recv,
			RECV_PACKET_SIZE, 0, (struct sockaddr*)&sin_recv,
			&fromlen )) < 0 ) {
		    report_printf( r, "recvfrom: %m" );
		    return( T_MAYBE_DOWN );
		}

		if ( bcmp( &sin_recv.sin_addr, &t->t_sin.sin_addr,
			sizeof( struct in_addr )) == 0 ) {

		    if (( icmp_recv->icmp_type == ICMP_ECHOREPLY ) &&
			    ( icmp_recv->icmp_id == icmp_send->icmp_id ) &&
		    	    ( icmp_recv->icmp_seq >= icmp_send->icmp_seq -
			    attempt ) && ( strcmp( send_message,
			    recv_message ) == 0 )) {

			/* packet is echo reply packet, from our pid, with our
			 * message, in a range of packets that we'll consider.
			 */

#ifdef notdef
			if ( icmp_recv->icmp_seq == icmp_send->icmp_seq ) {
			    /* very likely the exact packet we want */
			} else {
			    /* XXX older packet that we'll accept anyway */
			}
#endif /* notdef */

			if ( time_end( tv_recv ) < 0 ) {
			    report_printf( r, "time_end: %m" );
			    return( T_MAYBE_DOWN );
			}

			syslog( LOG_INFO, "%s %s %s %d %ld.%.6ld", t->t_rlist,
				t->t_machine->m_name, t->t_name, attempt + 1,
				tv_recv->tv_sec, tv_recv->tv_usec );
			return( T_UP );
		    }
		}
	    }
	}
    }
    if ( same_host > 0 ) {
	/* nothing as of now */
	/* XXX maybe syslog? */
    }
    report_printf( r, "Timeout" );
    return( T_MAYBE_DOWN );
}
