/*********         imap.c         **********/

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <sys/time.h>

#include <syslog.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <errno.h>

#include <snet.h>

#include "nefu.h"

#define	TIME		120


    int
test_imap( struct test *t, struct report *r )
{
    int			s;
    int			result = T_UP;
    SNET		*n;
    struct timeval	tv;
    char		*line;
    char		*starok = "* OK";
    int			lenstarok = strlen( starok );
    char		*starbye = "* BYE";
    int			lenstarbye = strlen( starbye );
    char		*atom = "nefu1";
    char		*atomok = "nefu1 OK";
    int			lenatomok = strlen( atomok );
    int			maxwait;

    if (( s = socket( AF_INET, SOCK_STREAM, 0 )) < 0 ) {
	report_printf( r, "socket: %m" );
	return( T_MAYBE_DOWN );
    }

    if ( connect( s, (struct sockaddr *)&t->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	if ( errno == ECONNREFUSED ) {
	    result = T_DOWN;
	} else {
	    result = T_MAYBE_DOWN;
	}
	report_printf( r, "connect: %m" );
	goto done;
    }

    if (( n = snet_attach( s, 10240 )) == NULL ) {
	report_printf( r, "snet_attach: %m" );
	result = T_MAYBE_DOWN;
	goto done;
    }

    maxwait = TIME;
    if (( nefu_test_maxwait >= 0 ) && ( maxwait > nefu_test_maxwait )) {
	maxwait = nefu_test_maxwait;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( line = snet_getline( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( strncmp( line, starok, lenstarok ) != 0 ) {
	report_printf( r, "%s", line );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    if ( snet_writef( n, "%s LOGOUT\r\n", atom ) < 0 ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( line = snet_getline( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( strncmp( line, starbye, lenstarbye ) != 0 ) {
	report_printf( r, "%s", line );
	result = T_MAYBE_DOWN;
	goto done2;
    }

    tv.tv_sec = maxwait;
    tv.tv_usec = 0;

    if (( line = snet_getline( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	result = T_MAYBE_DOWN;
	goto done2;
    }
    if ( strncmp( line, atomok, lenatomok ) != 0 ) {
	report_printf( r, "%s", line );
	result = T_MAYBE_DOWN;
	goto done2;
    }

done2:
    snet_close( n );
done:
    close( s );
    return( result );
}
