#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>

#include <errno.h>
#include <ctype.h>
#include <unistd.h>
#include <strings.h>
#include <string.h>
#include <stdio.h>

#include "snet.h"

#include "nefu.h"


#define	USAGE	"usage: http [ timeout ] [ url ]"


    char *
init_http( struct test *t )
{
    switch ( t->t_argc ) {
    case 2:
    case 1:
	if ( atoi( t->t_argv[ 0 ]) <= 0 ) {
	    return( USAGE );
	}
    case 0:
	break;

    default:
	return( USAGE );
    }
    return( NULL );
}


    int
test_http( struct test *t_node, struct report *r )
{
    int			state = T_UP, s;
    struct timeval	tv;
    SNET		*n;
    char		*line, *uri = "/", *p;

    tv.tv_sec = 10;
    tv.tv_usec = 0;

    if (( nefu_test_maxwait >= 0 ) && ( tv.tv_sec > nefu_test_maxwait )) {
	tv.tv_sec = nefu_test_maxwait;
    }

    switch ( t_node->t_argc ) {
    case 2:
	uri = t_node->t_argv[ 1 ];
    case 1:
	if (( tv.tv_sec = atoi( t_node->t_argv[ 0 ])) <= 0 ) {
	    report_printf( r, USAGE );
	    return( T_DOWN );
	}
    case 0:
	break;

    default:
	report_printf( r, USAGE );
	return( T_DOWN );
    }


    if ( t_node->t_argc == 1 ) {
    }
   
    if (( s = socket( PF_INET, SOCK_STREAM, 0 )) < 0 ) {
	report_printf( r, "socket: %m" );
	return( T_MAYBE_DOWN );
    }

    if ( connect( s, (struct sockaddr *)&t_node->t_sin,
	    sizeof( struct sockaddr_in )) < 0 ) {
	if ( errno == ECONNREFUSED ) {
	    state = T_DOWN;
	} else {
	    state = T_MAYBE_DOWN;
	}
	report_printf( r, "%m" );
	close( s );
	return( state );
    }

    if (( n = snet_attach( s, 1024 * 1024 )) == NULL ) {
	report_printf( r, "%m" );
	state = T_MAYBE_DOWN;
	goto done;
    }

    if ( snet_writef( n, "HEAD %s HTTP/1.0\r\n\r\n", uri ) == 0 ) { 
	report_printf( r, "%m" );
	state = T_MAYBE_DOWN;
	goto done;
    }

    if (( line = snet_getline( n, &tv )) == NULL ) {
	report_printf( r, "%m" );
	state = T_MAYBE_DOWN;
	goto done;
    } 

    if (( p = strchr( line, ' ' )) == NULL ) {
	report_printf( r, "bad format: %s", line );
	state = T_DOWN;
	goto done;
    }

    p++;
    if ( *p == '2' || *p == '3' ) { /* 2xx and 3xx are OK */
	state = T_UP;
    } else if ( isdigit( (int)*p ) ) {
	report_printf( r, "%s", p );
	state = T_DOWN;
    } else {
	report_printf( r, "bad response: %s", line );
	state = T_DOWN;
    } 

    do {
	line = snet_getline( n, &tv );
    } while (( line != NULL ) && ( *line != '\0' ));

    if ( line == NULL ) {
	report_printf( r, "%m" );
	state = T_MAYBE_DOWN;
	goto done;
    }

done:
    if ( snet_close( n ) != 0 ) {
	report_printf( r, "%m" );
	state = T_MAYBE_DOWN;
    }
    return( state );
}
