#include <algorithm>
#include <cassert>
#include <cstdlib>
#include <sstream>
#include <string>
#include <utility>
#include <vector>

#include "nds.hh"
#include "test_macros.hh"

//H1:DMT-SNSH_EFFECTIVE_RANGE_MPC.mean,m-trend
//[1167530460-1178294460)


int main(int argc, char *argv[]) {
    std::vector<std::string> args = convert_args(argc, argv);

    //---------------------------------------------------------------------
    // Obtain the port of the server
    //---------------------------------------------------------------------
    NDS::connection::port_type	port = 31200;
    if ( std::getenv("NDS_TEST_PORT") )
    {
        std::istringstream	ps( ::getenv("NDS_TEST_PORT") );

        ps >> port;
    }
    std::string hostname("localhost");
    if ( std::getenv("NDS_TEST_HOST") )
    {
        hostname = std::getenv( "NDS_TEST_HOST" );
    }

    NDS_SHARED_PTR<NDS::connection> conn(new NDS::connection(hostname, port));
    conn->set_parameter("GAP_HANDLER", "STATIC_HANDLER_ZERO");
    conn->set_parameter("ALLOW_DATA_ON_TAPE", "true");
    conn->set_parameter("ITERATE_USE_GAP", "false");

    NDS::buffer::gps_second_type start = 1167530460;
    NDS::buffer::gps_second_type stop = 1178294460;
    NDS::connection::channel_names_type names;
    names.push_back("H1:DMT-SNSH_EFFECTIVE_RANGE_MPC.mean,m-trend");

    std::vector<std::string> expected;
    expected.push_back("66.7626");
    expected.push_back("0");
    expected.push_back("67.4257");
    expected.push_back("0");
    expected.push_back("0");
    expected.push_back("0");

    std::vector<std::string> actual;

    int block_count = 0;
    NDS::buffer::gps_second_type last_gps = 0;

    conn->iterate(start, stop, names);
    try {
        while (true) {
            NDS::buffers_type bufs = conn->next();
            ++block_count;
            last_gps = bufs[0]->Stop();
            const double *data = reinterpret_cast<const double*>(&((*bufs[0])[0]));
            // the first sample is all zeros, so ask for something later
            {
                std::ostringstream ss;
                ss << data[120];
                actual.push_back(ss.str());
            }
        }
    } catch (std::out_of_range&) {

    }
    assert(block_count == 6);
    assert(last_gps == 1178294460);
    assert(expected.size() == actual.size());
    for (int i = 0; i < expected.size(); ++i) {
        assert( expected[i] == actual[i]);
    }

    return 0;
}