#include "nds.hh"

#include <memory>
#include <cassert>
#include <cstdlib>
#include <iostream>
#include <sstream>

#include "nds_testing.hh"
#include "test_macros.hh"

int
main(int argc, char *argv[]) {
    using NDS::connection;

    std::vector <std::string> args = convert_args(argc, argv);

    //---------------------------------------------------------------------
    // Obtain the port of the server
    //---------------------------------------------------------------------
    connection::port_type port = 31200;
    if (std::getenv("NDS_TEST_PORT")) {
        std::istringstream ps(::getenv("NDS_TEST_PORT"));

        ps >> port;
    }
    std::string hostname("localhost");
    if (std::getenv("NDS_TEST_HOST")) {
        hostname = std::getenv("NDS_TEST_HOST");
    }
    connection::protocol_type proto = connection::PROTOCOL_TWO;
    std::cerr << "Connecting to " << hostname << ":" << port << " " << proto << std::endl;
    pointer< connection > conn( new connection( hostname, port, proto ));

    conn->set_epoch(1000000000, 1000000002);
    NDS::channels_type channels_list_two_sec = conn->find_channels("*");

    NDS::channels_type channels_list_two_sec_a = conn->find_channels("*",
       (NDS::channel::channel_type)(NDS::channel::CHANNEL_TYPE_STREND | NDS::channel::CHANNEL_TYPE_MTREND));

    conn->set_epoch(1000000000, 1000000001);
    NDS::channels_type channels_list_one_sec = conn->find_channels("*");

    NDS::channels_type channels_list_one_sec_a = conn->find_channels("*",
       (NDS::channel::channel_type)(NDS::channel::CHANNEL_TYPE_STREND | NDS::channel::CHANNEL_TYPE_MTREND));

    assert( channels_list_two_sec.size() > channels_list_one_sec.size() );
    assert( channels_list_two_sec_a.size() > channels_list_one_sec_a.size() );
}