#include "nds.hh"

#include <memory>
#include <cassert>
#include <iostream>
#include <cstdlib>
#include <sstream>

#include "test_macros.hh"
#include "nds_testing.hh"

int
main(int argc, char *argv[]) {
    using NDS::connection;

    std::vector<std::string> args = convert_args ( argc, argv );

    //---------------------------------------------------------------------
    // Obtain the port of the server
    //---------------------------------------------------------------------
    connection::port_type	port = 31200;
    if ( ::getenv("NDS_TEST_PORT") )
    {
        std::istringstream	ps( ::getenv("NDS_TEST_PORT") );

        ps >> port;
    }
    std::string hostname("localhost");
    if ( ::getenv("NDS_TEST_HOST") )
    {
        hostname = ::getenv( "NDS_TEST_HOST" );
    }
    connection::protocol_type proto = connection::PROTOCOL_TWO;

    std::cerr << "Connecting to " << hostname << ":" << port << " " << proto << std::endl;
    pointer< connection > conn( new connection( hostname, port, proto ));

    connection::channel_names_type ch;
    ch.push_back("H1:DAQ-DC0_GPS");

    conn->set_parameter("GAP_HANDLER", "STATIC_HANDLER_ZERO");
    conn->set_parameter("ITERATE_USE_GAP_HANDLERS", "TRUE");

    bool error_with_iterate = false;
    try {
        conn->iterate(1169928640, 1169928640 + 2, 1, ch);
        //conn->fetch(1169928640, 1169928640 + 2, ch);
    } catch (NDS::connection::daq_error & /* err */ ) {
        error_with_iterate = true;
    }
    assert ( error_with_iterate );

    conn->set_parameter("ITERATE_USE_GAP_HANDLERS", "FALSE");
    bool error_without_iterate = false;
    try {
        conn->iterate(1169928640, 1169928640 + 2, 1, ch);
        //conn->fetch(1169928640, 1169928640 + 2, ch);
    } catch (NDS::connection::daq_error & /* err */ ) {
        error_without_iterate = true;
    }
    assert ( error_without_iterate );
    return 0;
}
