#include "nds.hh"
#include "nds_testing.hh"
#include "test_macros.hh"

#include <algorithm>
#include <exception>
#include <cassert>
#include <cmath>
#include <cstdlib>
#include <cstring>
#include <iostream>
#include <fstream>
#include <sstream>
#include <vector>

using NDS::connection;

int
main(int argc, char **argv)
{
	std::vector<std::string> args = convert_args( argc, argv );

	connection::port_type port = 31200;
	if ( ::getenv("NDS_TEST_PORT" ))
	{
		std::istringstream ps( ::getenv("NDS_TEST_PORT") );
		ps >> port;
	}

	std::string hostname( "localhost" );
	if ( ::getenv("NDS_TEST_HOST"))
		hostname = ::getenv("NDS_TEST_HOST");

	// This test only runs against NDS2
	connection::protocol_type proto = connection::PROTOCOL_TWO;

	std::cerr << "Connecting to " << hostname << ":" << port << " ndsv2" << std::endl;

	pointer< connection > conn( new connection( hostname, port, proto ));
	assert( conn->get_port( ) == port );
	assert( conn->get_protocol( ) == 2 );

	conn->set_parameter("GAP_HANDLER", "ABORT_HANDLER");

	connection::channel_names_type cn;
	cn.push_back("H1:ISI-BS_ST1_SENSCOR_GND_STS_X_BLRMS_30M_100M.mean,s-trend");

	NDS::buffer::gps_second_type gps_start = 1116286100, gps_end = 1116286150;

	NDS::buffers_type bufs;
	bool had_err = false;
	try {
		bufs = conn->fetch( gps_start, gps_end, cn );
	} catch (const NDS::connection::daq_error& err) {
		had_err = true;
		assert(std::strstr(err.what(), "None of the selected channels returned data.")  != (char*)0 );
	}
	assert( had_err );

	conn->shutdown();
	conn->close();

	return 0;
}
