#include "daqc.h"

#include "nds.hh"
#include "nds_channel.hh"
#include "nds_str_helper.hh"

#include <string>

namespace NDS
{


  const std::string&
  channel_type_to_string( channel::channel_type ctype )
  {
     switch( ctype )
      {
      case channel::CHANNEL_TYPE_ONLINE:
        {
          static std::string v( cvt_chantype_str(cOnline) );
          return( v );
        }
        break;
      case channel::CHANNEL_TYPE_RAW:
        {
          static std::string v( cvt_chantype_str(cRaw) );
          return( v );
        }
        break;
      case channel::CHANNEL_TYPE_RDS:
        {
          static std::string v( cvt_chantype_str(cRDS) );
          return( v );
        }
        break;
      case channel::CHANNEL_TYPE_STREND:
        {
          static std::string v( cvt_chantype_str(cSTrend) );
          return( v );
        }
        break;
      case channel::CHANNEL_TYPE_MTREND:
        {
          static std::string v( cvt_chantype_str(cMTrend) );
          return( v );
        }
        break;
      case channel::CHANNEL_TYPE_TEST_POINT:
        {
          static std::string v( cvt_chantype_str(cTestPoint) );
          return( v );
        }
        break;
      case channel::CHANNEL_TYPE_STATIC:
        {
          static std::string v( cvt_chantype_str(cStatic) );
          return( v );
        }
        break;
      default:
        {
          static std::string v( "UNKNOWN" );
          return( v );
        }
        break;
      }
  }

  const std::string&
  data_type_to_string( channel::data_type dtype )
  {
  	switch( dtype )
  	{
  	case channel::DATA_TYPE_INT16:
  		{
  			static std::string v( data_type_name( _16bit_integer ) );
  			return v;
  		}
  		break;
  	case channel::DATA_TYPE_INT32:
  		{
  			static std::string v( data_type_name( _32bit_integer ) );
  			return v;
  		}
  		break;
  	case channel::DATA_TYPE_INT64:
  		{
  			static std::string v( data_type_name( _64bit_integer ) );
  			return v;
  		}
  		break;
  	case channel::DATA_TYPE_FLOAT32:
  		{
  			static std::string v( data_type_name( _32bit_float ) );
  			return v;
  		}
  		break;
  	case channel::DATA_TYPE_FLOAT64:
  		{
  			static std::string v( data_type_name( _64bit_double ) );
  			return v;
  		}
  		break;
  	case channel::DATA_TYPE_COMPLEX32:
  		{
  			static std::string v( data_type_name( _32bit_complex ) );
  			return v;
  		}
  		break;
  	case channel::DATA_TYPE_UINT32:
  		{
  			static std::string v( data_type_name( _32bit_uint ) );
  			return v;
  		}
  		break;
  	default:
  		{
  			static std::string v( "undefined" );
  			return v;
  		}
  		break;
  	}
  }

}