/* -*- mode: C++ ; c-basic-offset: 2; indent-tabs-mode: nil -*- */

#ifndef SWIG__COMMON__NDS_PARAMS_HH
#define SWIG__COMMON__NDS_PARAMS_HH

#include <string>
#include <vector>
#include <memory>

#include "nds_gap_handler.hh"

namespace NDS
{
  //-----------------------------------------------------------------
  /// \brief A parameter block describes parameters affecting the
  /// behavior of the NDS::connection
  //-----------------------------------------------------------------

  class parameter_block
  {
  private:
  	std::string _gap_handler_string;
  	std::auto_ptr< NDS::gap_handler > _gap_handler;

	int  _max_nds1_command_count;
  	bool _allow_data_on_tape;
    bool _iterate_uses_gap_handler;

  	bool extract_bool_value(const std::string &str, bool &dest);
  	bool set_gap_handler(const std::string &handler_str);

  	// explicitly undefined
  	parameter_block(const parameter_block &other);
  	parameter_block &operator=(const parameter_block &other);
  public:
  	parameter_block();

  	// should this just fold into the constructor ?
  	void initialize_from_env();

  	// Get the string representation of the given parameter, or ""
  	// if the parameter does not exist
  	std::string get(const std::string &parameter) const;

  	// Set the string representation of a parameter
  	// @param[in] parameter - The name of the parameter to set
  	// @param[in] value - The string representation of the value
  	// @returns - true if the value could be set, else false
  	bool set(const std::string &parameter, const std::string &value);

  	// Return a sequence of strings listing all the parameters
  	// that can be set
  	//
  	// @returns std::vector<std::string> contianing parameter names
  	std::vector<std::string> parameters() const;

  	// Return the standard prefix that should be applied to
  	// the parameter name when reading it from the environment
  	std::string env_prefix() const;

	// After how many commands should we cycle an nds1 connection
	int max_nds1_command_count() const { return _max_nds1_command_count; }

  	// Are requests allowed to read data from tape?
  	bool allow_data_on_tape() const { return _allow_data_on_tape; };

  	// Retrieve gap handler
  	NDS::gap_handler *gap_handler() const { return _gap_handler.get(); }

    // Should iterate use the gap handler
    bool iterate_uses_gap_handler() const { return _iterate_uses_gap_handler; }
  };
}

#endif // SWIG__COMMON__NDS_PARAMS_HH