#ifndef __NDS_ITERATE_HANDLER_HH__
#define __NDS_ITERATE_HANDLER_HH__

#include "nds_buffer_internal.hh"
#include "nds_channel_internal.hh"
#include "nds_epoch.hh"
#include "nds_request_fragment.hh"

namespace NDS
{

  /**
   * @class iterate_handler
   * @note Generic interface to objects that handle the streaming data/iterate interface
   */
  class iterate_handler {
  public:
	  virtual bool has_next() = 0;
	  virtual void next(buffers_type_intl&) = 0;
	  virtual ~iterate_handler() {}

	  virtual bool done() {
		  return !has_next();
	  }
  };

}


#endif // __NDS_ITERATE_HANDLER_HH__
