#ifndef SWIG__COMMON__NDS_EPOCH_HH
#define SWIG__COMMON__NDS_EPOCH_HH

#include <string>
#include <ostream>
#include <utility>
#include <vector>

#include <iostream>

#include "nds_memory.hh"

namespace NDS
{
	class epoch {
	public:
		std::string name;
		buffer::gps_second_type gps_start;
		buffer::gps_second_type gps_stop;

		epoch():name(""), gps_start(0), gps_stop(0) {
		};
		epoch(const std::string& name, buffer::gps_second_type start, buffer::gps_second_type stop): name(name), gps_start(start), gps_stop(stop) {
		};
		epoch(const epoch &other): name(other.name), gps_start(other.gps_start), gps_stop(other.gps_stop) {
		};
		~epoch() {
		};
	};

	inline std::ostream &operator<<(std::ostream& os, const epoch& obj)
	{
		os << "< epoch ";
		if (obj.name == "") {
			os << obj.gps_start << "-" << obj.gps_stop;
		} else {
			os << obj.name;
		}
		os << " >";
		return os;
	}

	typedef std::vector< NDS_SHARED_PTR< epoch > > epochs_type;

	inline std::ostream &operator<<(std::ostream& os, const epochs_type& obj)
	{
		os << "(";
		epochs_type::const_iterator cur = obj.begin();
		for (; cur != obj.end(); ++cur) {
			os << " " << **cur << ",";
		}
		os << " )";
		return os;
	}
}

#endif
