/* -*- mode: C++ ; c-basic-offset: 2; indent-tabs-mode: nil -*- */

#ifndef SWIG__COMMON__NDS_DB_SQLITE3_HH
#define SWIG__COMMON__NDS_DB_SQLITE3_HH

#include <sqlite3.h>

#include "nds_db.hh"

namespace NDS
{
  namespace ChannelCache
  {
    class daq_channels_type;

    class sqlite3db
      : public db
    {
    public:
      typedef sqlite3*	handle_type;
      typedef long timeout_type;

      static const handle_type NULL_HANDLE;
      static const timeout_type HASH_CHECK_INTERVAL;

      sqlite3db( const connection& Server );

      virtual ~sqlite3db( );

	  virtual size_t count_channels( std::string channel_glob,
					   channel::channel_type channel_type_mask,
					   channel::data_type data_type_mask,
					   channel::sample_rate_type min_sample_rate,
					   channel::sample_rate_type max_sample_rate,
					   bool use_glob );

      virtual channels_type_intl find_channels( std::string channel_glob,
					   channel::channel_type channel_type_mask,
					   channel::data_type data_type_mask,
					   channel::sample_rate_type min_sample_rate,
					   channel::sample_rate_type max_sample_rate,
					   bool use_glob );

    private:
      enum query_type {
          COUNT_QUERY,
          FIND_QUERY
      };

      const connection&	server;
      handle_type	cache;
      std::string	db_dir;
      bool		readonly;

      //-------------------------------------------------------------------
      /// \brief Update the cache of channels
      //-------------------------------------------------------------------
      void channels( daq_channels_type& Channels );

      std::string create_sql_query(query_type type,
                                   std::string channel_glob,
                                   channel::channel_type channel_type_mask,
                                   channel::data_type data_type_mask,
                                   channel::sample_rate_type min_sample_rate,
                                   channel::sample_rate_type max_sample_rate,
                                   bool use_glob);


      void update( );

      //-------------------------------------------------------------------
      /// \brief Updates outdated hash value
      ///
      /// \param[in] Server
      ///     The currently connected NDS server
      ///
      /// \return
      ///     The value \b true is returned if the hash was updated,
      ///     \b false otherwise.
      //-------------------------------------------------------------------
      bool update_hash( );

      //-------------------------------------------------------------------
      //-------------------------------------------------------------------
      void _db_find( bool Create );

      bool _db_open( bool Create );
    };
  }
}

#endif /* SWIG__COMMON__NDS_DB_SQLITE3_HH */
