/* -*- mode: C++ ; c-basic-offset: 2; indent-tabs-mode: nil -*- */

#ifndef SWIG__COMMON__NDS_DB_HH
#define SWIG__COMMON__NDS_DB_HH

#include <sys/types.h>

#include "nds_channel.hh"
#include "nds_channel_internal.hh"

namespace NDS
{
  class connection;

  class db
  {
  public:
    typedef int protocol_type;
    typedef time_t timestamp_type;

    db( );

    virtual ~db( );

	virtual size_t count_channels( std::string channel_glob,
					 channel::channel_type channel_type_mask,
					 channel::data_type data_type_mask,
					 channel::sample_rate_type min_sample_rate,
					 channel::sample_rate_type max_sample_rate,
					 bool use_glob = true ) = 0;

    virtual channels_type_intl find_channels( std::string channel_glob,
					 channel::channel_type channel_type_mask,
					 channel::data_type data_type_mask,
					 channel::sample_rate_type min_sample_rate,
					 channel::sample_rate_type max_sample_rate,
					 bool use_glob = true ) = 0;

    static db* create( const connection& Server );

    const timestamp_type& Timestamp( ) const;

  protected:
    void timestamp( const timestamp_type& Value );

  private:
    timestamp_type	timestamp_;
  };

  inline const db::timestamp_type& db::
  Timestamp( ) const
  {
    return timestamp_;
  }

  inline void db::
  timestamp( const timestamp_type& Value )
  {
    timestamp_ = Value;
  }
}

#endif /* SWIG__COMMON__NDS_DB_HH */
