#include "nds.hh"
#include "nds_connection_ptype.hh"
#include "nds_db.hh"
#include "nds_db_sqlite3.hh"

#include "bash_pattern.h"

using NDS::channel;
using NDS::connection;
using NDS::db;

namespace NDS
{
  //---------------------------------------------------------------------
  // db
  //---------------------------------------------------------------------
  db::
  db( )
    : timestamp_( 0 )
  {
  }

  db::
  ~db( )
  {
  }

  db* db::
  create( const connection& Server )
  {
    db* retval = (db*)NULL;

    switch( Server.get_protocol( ) )
    {
    case connection::PROTOCOL_ONE:
    case connection::PROTOCOL_TWO:
      retval = new ChannelCache::sqlite3db( Server );
      break;
    default:
      /// \todo Should throw an exception
      break;
    }

    return retval;
  }
}
