#include <cstddef>

#include "nds_bash_pattern.hh"

namespace NDS
{
  typedef int daq_result_type;
  static bash_pattern_t* null_bash_pattern = ((bash_pattern_t*)NULL);

  //---------------------------------------------------------------------
  // bash_pattern_t
  //---------------------------------------------------------------------

  bash_pattern::
  bash_pattern( const char* expression )
    : compiled_expr( null_bash_pattern )
  {
    compiled_expr = bash_pattern_compile(expression);
  }

  bash_pattern::
  ~bash_pattern( )
  {
    bash_pattern_free( compiled_expr );
  }

  int bash_pattern::
  matches(const char* text)
  {
    return bash_pattern_matches(compiled_expr, text);
  }
}
