#include "nds_buffer.hh"
#include "nds_availability.hh"
#include "nds_availability_helper.hh"
#include "nds_helper.hh"

#include <algorithm>
#include <map>

namespace NDS
{
	bool
	gaps_equivalent_pred( NDS_SHARED_PTR< simple_segment > e1, NDS_SHARED_PTR< simple_segment > e2)
	{
		return ( e1->gps_start == e2->gps_start && e1->gps_stop == e2->gps_stop );
	}

	bool
	gaps_equivalent(const simple_segment_list_type& l1, const simple_segment_list_type& l2)
	{
		if ( l1.size() != l2.size() ) return false;
		return std::equal ( l1.begin(), l1.end(), l2.begin(), gaps_equivalent_pred );
	}

	segment::segment():frame_type(""), gps_start(0), gps_stop(0) {}

	segment::segment(NDS::buffer::gps_second_type gps_start,
					 NDS::buffer::gps_second_type gps_stop):
		frame_type(""), gps_start(gps_start), gps_stop(gps_stop) {}

	segment::segment(std::string frame_type,
					 NDS::buffer::gps_second_type gps_start,
					 NDS::buffer::gps_second_type gps_stop):
		frame_type(frame_type), gps_start(gps_start), gps_stop(gps_stop) {}

	simple_segment::simple_segment(): gps_start(0), gps_stop(0)
	{}

	simple_segment::simple_segment(const simple_segment &other):
		gps_start(other.gps_start), gps_stop(other.gps_stop)
	{}

	simple_segment::simple_segment(gps_second_type start, gps_second_type stop):
		gps_start(start), gps_stop(stop)
	{}

	simple_segment &simple_segment::operator=(const simple_segment &other)
	{
		gps_start = other.gps_start;
		gps_stop = other.gps_stop;
		return *this;
	}

        NDS_SHARED_PTR< simple_segment_list_type >
	availability::simple_list() const
	{
		return simplify_availability(*this);
	}

	simple_availability_list_type availability_list_type::simple_list() const {
		return simplify_availability_list(*this);
	}
}
