// ----------------------------------------------------------------------
/// \if ( DEVELOPER_SECTION )
/// \mainpage Developer Documentation
/// \section DEV_ABSTRACT Abstract
///
/// The purpose of this documentation is to provided detailed information
/// about the NDS client library to those wanting to further develope
/// the NDS client library.
/// It is <b>NOT</b> intended for those who simply want to use or
/// develope applications against the NDS client library
///
/// \section DEV_PLATFORMS Development Platforms
/// <!-- ============ L I N U X ( RedHat Derivative ) ============== -->
/// \subsection DEV_PLATFORMS_LINUX_RH Linux (Red Hat Derivative)
/// <!-- ============ L I N U X ( Debian Derivative ) ============== -->
/// \subsection DEV_PLATFORMS_LINUX_DEB Linux (Debian Derivative)
/// <!-- =========================== O S X ========================= -->
/// \subsection DEV_PLATFORMS_OSX OSX
/// \par CMake
/// CMake needs to be version 2.8.1 or later.
/// \verbatim
cmake -DENABLE_64BIT=yes -DWITH_SASL=no <source_dir>
\endverbatim
///
/// <!-- ======================= W I N D O W S ==================== --> 
/// \subsection DEV_PLATFORMS_WIN Windows
/// \par Python
/// Python (2.7 or 3.6) is used to run the unit tests along with
/// being a supported extension language.
/// To support running of unit tests, only the interpreter needs to be
/// installed.
/// It can be obtained from
/// <a href="http://www.python.org/downloads/windows">
/// www.python.org/downloads/windows</a>
///
/// \par
/// If using version 2.7 of Python, then the version of numpy needs to
/// be upgraded using the following command:
/// \Python27\python -m pip install --upgrade numpy
///
/// \par
/// If wanting to build debug version of library and using python,
/// the file 'pyconfig.h' in the python installation directory needs
/// to be edited to comment out '#define Py_DEBUG'.
/// Also, python27.lib needs to be copied to python27_d.lib.
///
/// \par SWIG
/// To be able to build the Java or Python extensions, SWIG is required.
/// The Windows version can be downloaded from
/// <a href="http://www.swig.org/downloads">www.swig.org/downloads</a>
/// Be sure to get the latest swigwin zip file.
/// 
/// \endif
// ----------------------------------------------------------------------
