#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
include( CMakeParseArguments )

function(set_cache_var VAR VALUE DESC)
  if( NOT ${VAR} )
    set( ${VAR} ${VALUE} )
  endif( NOT ${VAR} )
  set( ${VAR} ${${VAR}} CACHE INTERNAL ${DESC} )
endfunction(set_cache_var)

set_cache_var(
  PROJECT_DEBIAN_RULES_FILENAME
  "rules"
  "Debian Rules base name" )
set_cache_var(
  PROJECT_DEBIAN_RULES_INPUT_FILENAME
  PROJECT_DEBIAN_RULES_INPUT_FILENAME-NOTFOUND
  "Debian Rules file to use to generate distributed rules file" )
if( PROJECT_DEBIAN_RULES_INPUT_FILENAME )
  if( NOT PROJECT_DEBIAN_RULES_OUTPUT_FILENAME )
    set( PROJECT_DEBIAN_RULES_OUTPUT_FILENAME
      "${CMAKE_CURRENT_BINARY_DIR}/${PROJECT_DEBIAN_RULES_FILENAME}" )
  endif( NOT PROJECT_DEBIAN_RULES_OUTPUT_FILENAME )
endif( PROJECT_DEBIAN_RULES_INPUT_FILENAME )
set_cache_var(
  PROJECT_DEBIAN_RULES_OUTPUT_FILENAME
  "${CMAKE_SOURCE_DIR}/debian/${PROJECT_DEBIAN_RULES_FILENAME}"
  "Debian Rules file to use for distribution" )

function(ax_packaging_debian_file)
  set(options)
  set(oneValueArgs INPUT OUTPUT)
  set(multiValueArgs)
  cmake_parse_arguments(ARG "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

  if(NOT ARG_INPUT)
    set(ARG_INPUT "${CMAKE_SOURCE_DIR}/cmake/${PROJECT_NAME}.spec.in")
  endif(NOT ARG_INPUT)
  if(NOT ARG_OUTPUT)
    set(ARG_OUTPUT "${CMAKE_BINARY_DIR}/${PROJECT_NAME}.spec")
  endif(NOT ARG_OUTPUT)
  configure_file( ${ARG_INPUT} ${ARG_OUTPUT} @ONLY )
endfunction(ax_packaging_debian_file)

function(ax_packaging_deb)
  if ( PROJECT_DEBIAN_RULES_INPUT_FILENAME )
    ax_packaging_debian_file(
      INPUT ${PROJECT_DEBIAN_RULES_INPUT_FILENAME}
      OUTPUT ${PROJECT_DEBIAN_RULES_OUTPUT_FILENAME} )
  endif ( PROJECT_DEBIAN_RULES_INPUT_FILENAME )
  find_program(DEBBUILD dpkg-buildpackage)
  if (DEBBUILD)
    set(DEBSOURCEPKGORIG ${PACKAGE}_$(VERSION).orig.tar)
    set(DEBSOURCEPKG ${DEBSOURCEPKGORIG}.gz)
    set(DEBSOURCEDIR ${PACKAGE}-${VERSION})
    set(TAR_DIR_NAME "${PROJECT_NAME}-${${PROJECT_NAME}_VERSION}")
    set(TAR_NAME "${TAR_DIR_NAME}.tar.gz")
    set(DEBPKGTESTDIR "${CMAKE_CURRENT_BINARY_DIR}/tdebian")
    add_custom_target(deb
		      COMMAND ${CMAKE_COMMAND} -E echo "Building Debian  package..."
		      COMMAND ${CMAKE_COMMAND} -E make_directory ${DEBPKGTESTDIR}
		      COMMAND ${CMAKE_COMMAND} -E chdir ${DEBPKGTESTDIR} tar xfz "${CMAKE_CURRENT_BINARY_DIR}/${TAR_NAME}"
		      COMMAND ${CMAKE_COMMAND} -E chdir "${DEBPKGTESTDIR}/${TAR_DIR_NAME}" ${DEBBUILD} -rfakeroot -D -us -uc -b
		      )
    add_dependencies(deb dist)
  else (DEBBUILD)
    add_custom_target(deb
		      COMMAND ${CMAKE_COMMAND} -E echo "This platform does not support building of debian packages")
  endif(DEBBUILD)
endfunction(ax_packaging_deb)