/*
 * Unit tests against mock-up NDS 1 server
 *
 * Copyright (C) 2014  Leo Singer <leo.singer@ligo.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

package nds2;

import java.util.Map;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.xml.bind.DatatypeConverter;
import java.util.Arrays;

public final class test_mockup {

    public static ByteBuffer[] bytepatterns = {
	ByteBuffer.wrap(DatatypeConverter.parseHexBinary("B000")).order(ByteOrder.LITTLE_ENDIAN),
	ByteBuffer.wrap(DatatypeConverter.parseHexBinary("DEADBEEF")).order(ByteOrder.LITTLE_ENDIAN),
	ByteBuffer.wrap(DatatypeConverter.parseHexBinary("00000000FEEDFACE")).order(ByteOrder.LITTLE_ENDIAN),
    };

    public static void main(String[] args) throws java.io.UnsupportedEncodingException
    {
	Map<String, String> env = System.getenv();
	int port = Integer.parseInt(env.get("NDS_TEST_PORT"));

	connection conn = new nds2.connection("localhost", port, nds2.connection.PROTOCOL_ONE);
	assert conn.getPort() == port;
	assert conn.getProtocol() == 1;

	channel[] channels = conn.findChannels("X*:{A,B,C}");
	assert channels.length == 3;
	assert channels[0].toString().equals("<X1:A (16Hz, ONLINE, INT16)>");
	assert channels[1].toString().equals("<X1:B (16Hz, ONLINE, INT32)>");
	assert channels[2].toString().equals("<X1:C (16Hz, ONLINE, INT64)>");

	buffer[] bufs = conn.fetch(1000000000, 1000000004,
				   new String[] {"X1:A", "X1:B", "X1:C"});
	assert bufs.length == 3;
	for (int i = 0; i < bufs.length; i++) {
	    buffer buf = bufs[i];
	    assert buf.getGpsSeconds() == 1000000000;
	    assert buf.getGpsNanoseconds() == 0;

	    channel channel = buf.getChannel();
	    int chantype = channel.getDataType();
	    Object dataraw = buf.getData();

	    if (chantype == channel.DATA_TYPE_INT16) {
		short[] data = (short[]) dataraw;

		assert data.length == 4 * channel.getSampleRate();

		short[] test = new short[data.length];
		Arrays.fill(test, bytepatterns[i].getShort(0));
		assert Arrays.equals(data, test);

	    } else if (chantype == channel.DATA_TYPE_INT32) {
		int[] data = (int[]) dataraw;

		assert data.length == 4 * channel.getSampleRate();

		int[] test = new int[data.length];
		Arrays.fill(test, bytepatterns[i].getInt(0));
		assert Arrays.equals(data, test);

	    } else if (chantype == channel.DATA_TYPE_INT64) {
		long[] data = (long[]) dataraw;

		assert data.length == 4 * channel.getSampleRate();

		long[] test = new long[data.length];
		Arrays.fill(test, bytepatterns[i].getLong(0));
		assert Arrays.equals(data, test);

	    }
	}

	// connection automatically closed when garbage collected,
	// but test explicit close anyway
	conn.close();
    }
}
