% Add jar to Java classpath
javaaddpath(javadir);

% Open connection and print some information about the server
conn = nds2.connection('llocds.ligo-la.caltech.edu');
disp('Connection:'); disp(conn);
disp(sprintf('Host: %s', conn.getHost()));
disp(sprintf('Port: %d', conn.getPort()));
disp(sprintf('Protocol: %d', conn.getProtocol()));

% Get list of available channels and print some information about them
channels = conn.findChannels('L1:*PEM-EY*');
disp(sprintf('Number matching of channels: %d', length(channels)));
disp('First channel:'); disp(channels(1));
disp(sprintf('First channel name: %s', channels(1).getName()));

% Fetch some data
data = conn.fetch(1038296031, 1038296035, ...
    {'L1:PEM-EY_SEISX_OUT_DQ', 'L1:PEM-EY_SEISY_OUT_DQ', 'L1:PEM-EY_SEISZ_OUT_DQ'});
disp('A buffer:'); disp(data(1));
disp('Its data:'); disp(data(1).getData());
disp('Its channel:'); disp(data(1).getChannel());

disp('Now block by block...');
conn.iterate(1038296031, 1038296035, 1, {'L1:PEM-EY_SEISX_OUT_DQ', 'L1:PEM-EY_SEISY_OUT_DQ', 'L1:PEM-EY_SEISZ_OUT_DQ'})
while conn.hasNext()
    bufs = conn.next();
    disp(bufs);
end
