function datalist = NDS2_GetData(namelist, start, duration, server)
%NDS2_GetData  Get time series data from a LIGO NDS2 server.
%
% Usage:
%
%    datalist = NDS2_GetData(namelist, start, duration, server)
%
% Where:
%
%    namelist is a cell list of channel names and types, e.g. {'H1:LSC-DARM_ERR,online' 'H2:LSC-DARM_ERR'}
%    start    is the GPS start time of the requested data
%    duration is the number of seconds to fetch.
%    server   is a string with the NDS2 server ip address (or name) and port ('<ip-addr>:<port>')
%
%    datalist is a Matlab cell-array containing requested data
%             name           Channel name
%             channel_type   Channel type
%             rate           Sample rate (Hz)
%             data_type      Data type (string)
%             signal_gain    Online signal gain
%             signal_offset  Online signal offset
%             signal_slope   Online signal slope
%             signal_units   Online Signal unit string
%             start_gps_sec  Data start GPS time
%             duration_sec   Data duration in seconds
%             data           Data array
%             exists         Existence flag (non-existent == 0).
%
% Example:             
%
%    server = 'ldas-pcdev1.ligo.caltech.edu:31200';
%    result = NDS2_GetData({'L1:LSC-DARM_ERR'}, 957313530, 10, server);
%
% See also NDS_GetChannels, NDS_GetData and NDS2_GetChannels.
